/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.org.apache.zookeeper.AsyncCallback;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class NullDataTest
extends ClientBase
implements AsyncCallback.StatCallback {
    String snapCount;
    CountDownLatch cn = new CountDownLatch(1);

    public void setUp() throws Exception {
        this.snapCount = System.getProperty("zookeeper.snapCount", "1024");
        System.setProperty("zookeeper.snapCount", "10");
        super.setUp();
    }

    public void tearDown() throws Exception {
        System.setProperty("zookeeper.snapCount", this.snapCount);
        super.tearDown();
    }

    @Test
    public void testNullData() throws IOException, InterruptedException, KeeperException {
        String path = "/SIZE";
        TestableZooKeeper zk = null;
        zk = this.createClient();
        try {
            zk.create(path, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.exists(path, false);
            zk.exists(path, false, this, null);
            this.cn.await(10L, TimeUnit.SECONDS);
            Assert.assertSame((Object)0L, (Object)this.cn.getCount());
        }
        finally {
            if (zk != null) {
                zk.close();
            }
        }
    }

    public void processResult(int rc, String path, Object ctx, Stat stat) {
        this.cn.countDown();
    }
}

