/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.org.apache.zookeeper.proto.ConnectRequest;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.junit.Assert;
import org.junit.Test;

public class MaxCnxnsTest
extends ClientBase {
    private final int numCnxns = 30;
    AtomicInteger numConnected = new AtomicInteger(0);
    String host;
    int port;

    public void setUp() throws Exception {
        this.maxCnxns = 30;
        super.setUp();
    }

    @Test
    public void testMaxCnxns() throws IOException, InterruptedException {
        int i;
        String[] split = this.hostPort.split(":");
        this.host = split[0];
        this.port = Integer.parseInt(split[1]);
        int numThreads = 35;
        CnxnThread[] threads = new CnxnThread[numThreads];
        for (i = 0; i < 30; ++i) {
            threads[i] = new CnxnThread(i);
        }
        for (i = 0; i < 30; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 30; ++i) {
            threads[i].join();
        }
        Assert.assertSame((Object)30, (Object)this.numConnected.get());
    }

    class CnxnThread
    extends Thread {
        int i;
        SocketChannel socket;

        public CnxnThread(int i) {
            super("CnxnThread-" + i);
            this.i = i;
        }

        public void run() {
            try {
                SocketChannel sChannel = SocketChannel.open();
                sChannel.connect(new InetSocketAddress(MaxCnxnsTest.this.host, MaxCnxnsTest.this.port));
                ConnectRequest conReq = new ConnectRequest(0, 0L, 10000, 0L, "password".getBytes());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
                boa.writeInt(-1, "len");
                conReq.serialize((OutputArchive)boa, "connect");
                baos.close();
                ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
                bb.putInt(bb.capacity() - 4);
                bb.rewind();
                int eof = sChannel.write(bb);
                sChannel.socket().setSoTimeout(10000);
                if (!sChannel.socket().isClosed() && (eof = sChannel.socket().getInputStream().read()) != -1) {
                    MaxCnxnsTest.this.numConnected.incrementAndGet();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

