/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.server.LogFormatter;
import org.apache.hive.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hive.org.apache.zookeeper.server.SnapshotFormatter;
import org.apache.hive.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hive.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.UpgradeTest;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class InvalidSnapshotTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));
    private CountDownLatch startSignal;

    @Test
    public void testLogFormatter() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        File logfile = new File(new File(snapDir, "version-2"), "log.274");
        String[] args = new String[]{logfile.getCanonicalFile().toString()};
        LogFormatter.main((String[])args);
    }

    @Test
    public void testSnapshotFormatter() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        File snapfile = new File(new File(snapDir, "version-2"), "snapshot.272");
        String[] args = new String[]{snapfile.getCanonicalFile().toString()};
        SnapshotFormatter.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshot() throws Exception {
        File snapDir = new File(testData, "invalidsnap");
        ZooKeeperServer zks = new ZooKeeperServer(snapDir, snapDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        LOG.info("starting up the zookeeper server .. waiting");
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 20000, (Watcher)this);
        try {
            Assert.assertTrue((zk.exists("/9/9/8", false) != null ? 1 : 0) != 0);
        }
        finally {
            zk.close();
        }
        f.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:" + event.getState() + " " + event.getType() + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.startSignal != null && this.startSignal.getCount() > 0L) {
            this.startSignal.countDown();
        }
    }
}

