/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class DisconnectedWatcherTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(DisconnectedWatcherTest.class);
    final int TIMEOUT = 5000;

    @Test
    public void testChildWatcherAutoResetWithChroot() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort + "/ch1");
        zk2.getChildren("/", true);
        zk1.create("/youdontmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/youshouldmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/", (Object)e.getPath());
        MyWatcher childWatcher = new MyWatcher();
        zk2.getChildren("/", childWatcher);
        this.stopServer();
        watcher.waitForDisconnected(3000L);
        this.startServer();
        watcher.waitForConnected(3000L);
        zk1.create("/ch1/youshouldmatter2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/", (Object)e.getPath());
    }

    @Test
    public void testDefaultWatcherAutoResetWithChroot() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort + "/ch1");
        zk2.getChildren("/", true);
        zk1.create("/youdontmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/youshouldmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/", (Object)e.getPath());
        zk2.getChildren("/", true);
        this.stopServer();
        watcher.waitForDisconnected(3000L);
        this.startServer();
        watcher.waitForConnected(3000L);
        zk1.create("/ch1/youshouldmatter2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/", (Object)e.getPath());
    }

    @Test
    public void testDeepChildWatcherAutoResetWithChroot() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/here", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/here/we", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.create("/ch1/here/we/are", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort + "/ch1/here/we");
        zk2.getChildren("/are", true);
        zk1.create("/ch1/here/we/are/now", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = watcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/are", (Object)e.getPath());
        MyWatcher childWatcher = new MyWatcher();
        zk2.getChildren("/are", childWatcher);
        this.stopServer();
        watcher.waitForDisconnected(3000L);
        this.startServer();
        watcher.waitForConnected(3000L);
        zk1.create("/ch1/here/we/are/again", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/are", (Object)e.getPath());
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }
}

