/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class ClientHammerTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientHammerTest.class);
    private static final long HAMMERTHREAD_LATENCY = 5L;

    @Test
    public void testHammerBasic() throws Throwable {
        this.runHammer(10, 1000);
    }

    public void runHammer(int threadCount, int childCount) throws Throwable {
        try {
            HammerThread[] threads = new HammerThread[threadCount];
            long start = System.currentTimeMillis();
            for (int i = 0; i < threads.length; ++i) {
                TestableZooKeeper zk = this.createClient();
                String prefix = "/test-" + i;
                zk.create(prefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                prefix = prefix + "/";
                BasicHammerThread thread = new BasicHammerThread("BasicHammerThread-" + i, zk, prefix, childCount);
                thread.start();
                threads[i] = thread;
            }
            this.verifyHammer(start, threads, childCount);
        }
        catch (Throwable t) {
            LOG.error("test Assert.failed", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHammerSuper() throws Throwable {
        try {
            int threadCount = 5;
            int childCount = 10;
            HammerThread[] threads = new HammerThread[5];
            long start = System.currentTimeMillis();
            for (int i = 0; i < threads.length; ++i) {
                String prefix = "/test-" + i;
                TestableZooKeeper zk = this.createClient();
                try {
                    zk.create(prefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                finally {
                    zk.close();
                }
                prefix = prefix + "/";
                SuperHammerThread thread = new SuperHammerThread("SuperHammerThread-" + i, this, prefix, 10);
                thread.start();
                threads[i] = thread;
            }
            this.verifyHammer(start, threads, 10);
        }
        catch (Throwable t) {
            LOG.error("test Assert.failed", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyHammer(long start, HammerThread[] threads, int childCount) throws IOException, InterruptedException, KeeperException {
        int n;
        LOG.info("Starting check for completed hammers");
        int workingCount = threads.length;
        for (int i = 0; i < 120; ++i) {
            Thread.sleep(10000L);
            HammerThread[] hammerThreadArray = threads;
            n = hammerThreadArray.length;
            for (int j = 0; j < n; ++j) {
                HammerThread h = hammerThreadArray[j];
                if (h.isAlive() && h.current != h.count) continue;
                --workingCount;
            }
            if (workingCount == 0) break;
            workingCount = threads.length;
        }
        if (workingCount > 0) {
            HammerThread[] i = threads;
            int n2 = i.length;
            for (n = 0; n < n2; ++n) {
                HammerThread h = i[n];
                LOG.warn(h.getName() + " never finished creation, current:" + h.current);
            }
        } else {
            LOG.info("Hammer threads completed creation operations");
        }
        for (HammerThread h : threads) {
            int safetyFactor = 3;
            ClientHammerTest.verifyThreadTerminated(h, (long)(threads.length * childCount) * 5L * 3L);
        }
        LOG.info(new Date() + " Total time " + (System.currentTimeMillis() - start));
        TestableZooKeeper zk = this.createClient();
        try {
            int i;
            LOG.info("******************* Connected to ZooKeeper" + new Date());
            for (i = 0; i < threads.length; ++i) {
                LOG.info("Doing thread: " + i + " " + new Date());
                List children = zk.getChildren("/test-" + i, false);
                Assert.assertEquals((long)childCount, (long)children.size());
                children = zk.getChildren("/test-" + i, false, null);
                Assert.assertEquals((long)childCount, (long)children.size());
            }
            for (i = 0; i < threads.length; ++i) {
                List children = zk.getChildren("/test-" + i, false);
                Assert.assertEquals((long)childCount, (long)children.size());
                children = zk.getChildren("/test-" + i, false, null);
                Assert.assertEquals((long)childCount, (long)children.size());
            }
        }
        finally {
            zk.close();
        }
    }

    private static class SuperHammerThread
    extends HammerThread {
        private final ClientHammerTest parent;
        private final String prefix;

        SuperHammerThread(String name, ClientHammerTest parent, String prefix, int count) {
            super(name, count);
            this.parent = parent;
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] b = new byte[256];
            try {
                while (this.current < this.count) {
                    TestableZooKeeper zk = this.parent.createClient();
                    try {
                        zk.create(this.prefix + this.current, b, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    finally {
                        try {
                            zk.close();
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Unexpected", e);
                        }
                    }
                    ++this.current;
                }
            }
            catch (Throwable t) {
                LOG.error("Client create operation Assert.failed", t);
            }
        }
    }

    private static class BasicHammerThread
    extends HammerThread {
        private final ZooKeeper zk;
        private final String prefix;

        BasicHammerThread(String name, ZooKeeper zk, String prefix, int count) {
            super(name, count);
            this.zk = zk;
            this.prefix = prefix;
        }

        public void run() {
            byte[] b = new byte[256];
            try {
                while (this.current < this.count) {
                    Thread.sleep(5L);
                    this.zk.create(this.prefix + this.current, b, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    ++this.current;
                }
            }
            catch (Throwable t) {
                LOG.error("Client create operation Assert.failed", t);
            }
            finally {
                try {
                    this.zk.close();
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected", e);
                }
            }
        }
    }

    private static abstract class HammerThread
    extends Thread {
        protected final int count;
        protected volatile int current = 0;

        HammerThread(String name, int count) {
            super(name);
            this.count = count;
        }
    }
}

