/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.org.apache.zookeeper.AsyncCallback;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.JMXEnv;
import org.apache.hive.org.apache.zookeeper.test.QuorumBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncTest
extends ZKTestCase
implements AsyncCallback.StringCallback,
AsyncCallback.VoidCallback,
AsyncCallback.DataCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncTest.class);
    private QuorumBase qb = new QuorumBase();
    LinkedList<Integer> results = new LinkedList();

    @Before
    public void setUp() throws Exception {
        this.qb.setUp();
    }

    public void restart() throws Exception {
        JMXEnv.setUp();
        this.qb.startServers();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Test clients shutting down");
        this.qb.tearDown();
    }

    private ZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.qb.hostPort);
    }

    private ZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(hp, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        if (!watcher.clientConnected.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsync() throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = null;
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.create("/ben", new byte[0], (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, this.results);
            zk.create("/ben/2", new byte[0], (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, this.results);
            zk.delete("/ben", -1, (AsyncCallback.VoidCallback)this, this.results);
            zk.create("/ben2", new byte[0], (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, this.results);
            zk.getData("/ben2", false, (AsyncCallback.DataCallback)this, this.results);
            LinkedList<Integer> linkedList = this.results;
            synchronized (linkedList) {
                while (this.results.size() < 5) {
                    this.results.wait();
                }
            }
            Assert.assertEquals((long)0L, (long)this.results.get(0).intValue());
            Assert.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)KeeperException.Code.get((int)this.results.get(1)));
            Assert.assertEquals((long)0L, (long)this.results.get(2).intValue());
            Assert.assertEquals((long)0L, (long)this.results.get(3).intValue());
            Assert.assertEquals((long)0L, (long)this.results.get(4).intValue());
        }
        finally {
            zk.close();
        }
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd2".getBytes());
            try {
                zk.getData("/ben2", false, new Stat());
                Assert.fail((String)"Should have received a permission error");
            }
            catch (KeeperException e) {
                Assert.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)e.code());
            }
        }
        finally {
            zk.close();
        }
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.getData("/ben2", false, new Stat());
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, String name) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    private static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected = new CountDownLatch(1);

        private CountdownWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.clientConnected.countDown();
            }
        }
    }
}

