/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class ACLRootTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(ACLRootTest.class);

    @Test
    public void testRootAcl() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "pat:test".getBytes());
            zk.setACL("/", ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            zk.getData("/", false, null);
            zk.close();
            zk = this.createClient();
            try {
                zk.getData("/", false, null);
                Assert.fail((String)"validate auth");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            try {
                zk.create("/apps", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
                Assert.fail((String)"validate auth");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            zk.addAuthInfo("digest", "world:anyone".getBytes());
            try {
                zk.create("/apps", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
                Assert.fail((String)"validate auth");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "pat:test".getBytes());
            zk.getData("/", false, null);
            zk.create("/apps", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.delete("/apps", -1);
            zk.setACL("/", ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
            zk.close();
            zk = this.createClient();
            zk.getData("/", false, null);
            zk.create("/apps", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            try {
                zk.create("/apps", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
                Assert.fail((String)"validate auth");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            zk.delete("/apps", -1);
            zk.addAuthInfo("digest", "world:anyone".getBytes());
            zk.create("/apps", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            zk.delete("/apps", -1);
        }
        finally {
            zk.close();
        }
    }
}

