/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.version.util.VerGen;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class VerGenTest
extends ZKTestCase {
    private String input;
    private Object[] expected;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"1.2.3", new Object[]{1, 2, 3, null}}, {"1.2.3-dev", new Object[]{1, 2, 3, "dev"}}, {"1.2.3-SNAPSHOT", new Object[]{1, 2, 3, "SNAPSHOT"}}, {"1.2.3-foo-bar+123", new Object[]{1, 2, 3, "foo-bar+123"}});
    }

    public VerGenTest(String input, Object[] expected) {
        this.input = input;
        this.expected = expected;
    }

    @Test
    public void testParser() {
        VerGen.Version v = VerGen.parseVersionString((String)this.input);
        Assert.assertEquals((Object)this.expected[0], (Object)v.maj);
        Assert.assertEquals((Object)this.expected[1], (Object)v.min);
        Assert.assertEquals((Object)this.expected[2], (Object)v.micro);
        Assert.assertEquals((Object)this.expected[3], (Object)v.qualifier);
    }

    @Test
    public void testGenFile() throws Exception {
        VerGen.Version v = VerGen.parseVersionString((String)this.input);
        File outputDir = ClientBase.createTmpDir();
        VerGen.generateFile((File)outputDir, (VerGen.Version)v, (int)1, (String)"Nov1");
        ClientBase.recursiveDelete(outputDir);
    }
}

