/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper;

import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4ZKTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JUnit4ZKTestRunner.class);

    public JUnit4ZKTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new LoggedInvokeMethod(method, test);
    }

    public class LoggedInvokeMethod
    extends InvokeMethod {
        private String name;

        public LoggedInvokeMethod(FrameworkMethod method, Object target) {
            super(method, target);
            this.name = method.getName();
        }

        public void evaluate() throws Throwable {
            LOG.info("RUNNING TEST METHOD " + this.name);
            try {
                super.evaluate();
            }
            catch (Throwable t) {
                LOG.info("TEST METHOD FAILED " + this.name, t);
                throw t;
            }
            LOG.info("FINISHED TEST METHOD " + this.name);
        }
    }
}

