/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hive.org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.hive.org.apache.thrift.server.Invocation;
import org.apache.hive.org.apache.thrift.server.TNonblockingServer;
import org.apache.hive.org.apache.thrift.transport.TNonblockingServerTransport;

public class THsHaServer
extends TNonblockingServer {
    private final ExecutorService invoker;
    private final Args args;

    public THsHaServer(Args args) {
        super(args);
        this.invoker = args.executorService == null ? THsHaServer.createInvokerPool(args) : args.executorService;
        this.args = args;
    }

    protected void waitForShutdown() {
        this.joinSelector();
        this.gracefullyShutdownInvokerPool();
    }

    protected static ExecutorService createInvokerPool(Args options) {
        int minWorkerThreads = options.minWorkerThreads;
        int maxWorkerThreads = options.maxWorkerThreads;
        int stopTimeoutVal = options.stopTimeoutVal;
        TimeUnit stopTimeoutUnit = options.stopTimeoutUnit;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor invoker = new ThreadPoolExecutor(minWorkerThreads, maxWorkerThreads, stopTimeoutVal, stopTimeoutUnit, queue);
        return invoker;
    }

    protected void gracefullyShutdownInvokerPool() {
        long newnow;
        this.invoker.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.args.stopTimeoutUnit.toMillis(this.args.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.invoker.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    protected boolean requestInvoke(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        try {
            Runnable invocation = this.getRunnable(frameBuffer);
            this.invoker.execute(invocation);
            return true;
        }
        catch (RejectedExecutionException rx) {
            this.LOGGER.warn("ExecutorService rejected execution!", rx);
            return false;
        }
    }

    protected Runnable getRunnable(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        return new Invocation(frameBuffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends AbstractNonblockingServer.AbstractNonblockingServerArgs<Args> {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        private int stopTimeoutVal = 60;
        private TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
        private ExecutorService executorService = null;

        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }

        public Args minWorkerThreads(int n) {
            this.minWorkerThreads = n;
            return this;
        }

        public Args maxWorkerThreads(int n) {
            this.maxWorkerThreads = n;
            return this;
        }

        public int getMinWorkerThreads() {
            return this.minWorkerThreads;
        }

        public int getMaxWorkerThreads() {
            return this.maxWorkerThreads;
        }

        public int getStopTimeoutVal() {
            return this.stopTimeoutVal;
        }

        public Args stopTimeoutVal(int stopTimeoutVal) {
            this.stopTimeoutVal = stopTimeoutVal;
            return this;
        }

        public TimeUnit getStopTimeoutUnit() {
            return this.stopTimeoutUnit;
        }

        public Args stopTimeoutUnit(TimeUnit stopTimeoutUnit) {
            this.stopTimeoutUnit = stopTimeoutUnit;
            return this;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        public Args executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }
}

