/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.curator.framework.recipes.locks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.curator.framework.CuratorFramework;
import org.apache.hive.org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.hive.org.apache.curator.framework.recipes.locks.InterProcessMutex;

public class InterProcessMultiLock
implements InterProcessLock {
    private final List<InterProcessLock> locks;

    public InterProcessMultiLock(CuratorFramework client, List<String> paths) {
        this(InterProcessMultiLock.makeLocks(client, paths));
    }

    public InterProcessMultiLock(List<InterProcessLock> locks) {
        this.locks = ImmutableList.copyOf(locks);
    }

    private static List<InterProcessLock> makeLocks(CuratorFramework client, List<String> paths) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String path : paths) {
            InterProcessMutex lock2 = new InterProcessMutex(client, path);
            builder.add(lock2);
        }
        return builder.build();
    }

    @Override
    public void acquire() throws Exception {
        this.acquire(-1L, null);
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Exception exception = null;
        ArrayList<InterProcessLock> acquired = Lists.newArrayList();
        boolean success = true;
        for (InterProcessLock lock2 : this.locks) {
            try {
                if (unit == null) {
                    lock2.acquire();
                    acquired.add(lock2);
                    continue;
                }
                if (lock2.acquire(time, unit)) {
                    acquired.add(lock2);
                    continue;
                }
                success = false;
                break;
            }
            catch (Exception e) {
                success = false;
                exception = e;
            }
        }
        if (!success) {
            for (InterProcessLock lock2 : Lists.reverse(acquired)) {
                try {
                    lock2.release();
                }
                catch (Exception e) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
        return success;
    }

    @Override
    public synchronized void release() throws Exception {
        Exception baseException = null;
        for (InterProcessLock lock2 : Lists.reverse(this.locks)) {
            try {
                lock2.release();
            }
            catch (Exception e) {
                if (baseException == null) {
                    baseException = e;
                    continue;
                }
                baseException = new Exception(baseException);
            }
        }
        if (baseException != null) {
            throw baseException;
        }
    }

    @Override
    public synchronized boolean isAcquiredInThisProcess() {
        for (InterProcessLock lock2 : this.locks) {
            if (lock2.isAcquiredInThisProcess()) continue;
            return false;
        }
        return true;
    }
}

