/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.commons.math.stat.inference;

import org.apache.hive.org.apache.commons.math.MathException;
import org.apache.hive.org.apache.commons.math.MathRuntimeException;
import org.apache.hive.org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.hive.org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.hive.org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.hive.org.apache.commons.math.stat.inference.UnknownDistributionChiSquareTest;
import org.apache.hive.org.apache.commons.math.util.FastMath;

public class ChiSquareTestImpl
implements UnknownDistributionChiSquareTest {
    private ChiSquaredDistribution distribution;

    public ChiSquareTestImpl() {
        this(new ChiSquaredDistributionImpl(1.0));
    }

    public ChiSquareTestImpl(ChiSquaredDistribution x) {
        this.setDistribution(x);
    }

    public double chiSquare(double[] expected, long[] observed) throws IllegalArgumentException {
        if (expected.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, expected.length, 2);
        }
        if (expected.length != observed.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, expected.length, observed.length);
        }
        this.checkPositive(expected);
        this.checkNonNegative(observed);
        double sumExpected = 0.0;
        double sumObserved = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            sumExpected += expected[i];
            sumObserved += (double)observed[i];
        }
        double ratio = 1.0;
        boolean rescale = false;
        if (FastMath.abs(sumExpected - sumObserved) > 1.0E-5) {
            ratio = sumObserved / sumExpected;
            rescale = true;
        }
        double sumSq = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            double dev;
            if (rescale) {
                dev = (double)observed[i] - ratio * expected[i];
                sumSq += dev * dev / (ratio * expected[i]);
                continue;
            }
            dev = (double)observed[i] - expected[i];
            sumSq += dev * dev / expected[i];
        }
        return sumSq;
    }

    public double chiSquareTest(double[] expected, long[] observed) throws IllegalArgumentException, MathException {
        this.distribution.setDegreesOfFreedom((double)expected.length - 1.0);
        return 1.0 - this.distribution.cumulativeProbability(this.chiSquare(expected, observed));
    }

    public boolean chiSquareTest(double[] expected, long[] observed, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, alpha, 0, 0.5);
        }
        return this.chiSquareTest(expected, observed) < alpha;
    }

    public double chiSquare(long[][] counts) throws IllegalArgumentException {
        this.checkArray(counts);
        int nRows = counts.length;
        int nCols = counts[0].length;
        double[] rowSum = new double[nRows];
        double[] colSum = new double[nCols];
        double total = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                int n = row;
                rowSum[n] = rowSum[n] + (double)counts[row][col];
                int n2 = col;
                colSum[n2] = colSum[n2] + (double)counts[row][col];
                total += (double)counts[row][col];
            }
        }
        double sumSq = 0.0;
        double expected = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                expected = rowSum[row] * colSum[col] / total;
                sumSq += ((double)counts[row][col] - expected) * ((double)counts[row][col] - expected) / expected;
            }
        }
        return sumSq;
    }

    public double chiSquareTest(long[][] counts) throws IllegalArgumentException, MathException {
        this.checkArray(counts);
        double df = ((double)counts.length - 1.0) * ((double)counts[0].length - 1.0);
        this.distribution.setDegreesOfFreedom(df);
        return 1.0 - this.distribution.cumulativeProbability(this.chiSquare(counts));
    }

    public boolean chiSquareTest(long[][] counts, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, alpha, 0.0, 0.5);
        }
        return this.chiSquareTest(counts) < alpha;
    }

    public double chiSquareDataSetsComparison(long[] observed1, long[] observed2) throws IllegalArgumentException {
        if (observed1.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, observed1.length, 2);
        }
        if (observed1.length != observed2.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, observed1.length, observed2.length);
        }
        this.checkNonNegative(observed1);
        this.checkNonNegative(observed2);
        long countSum1 = 0L;
        long countSum2 = 0L;
        boolean unequalCounts = false;
        double weight = 0.0;
        for (int i = 0; i < observed1.length; ++i) {
            countSum1 += observed1[i];
            countSum2 += observed2[i];
        }
        if (countSum1 == 0L) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OBSERVED_COUNTS_ALL_ZERO, 1);
        }
        if (countSum2 == 0L) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OBSERVED_COUNTS_ALL_ZERO, 2);
        }
        boolean bl = unequalCounts = countSum1 != countSum2;
        if (unequalCounts) {
            weight = FastMath.sqrt((double)countSum1 / (double)countSum2);
        }
        double sumSq = 0.0;
        double dev = 0.0;
        double obs1 = 0.0;
        double obs2 = 0.0;
        for (int i = 0; i < observed1.length; ++i) {
            if (observed1[i] == 0L && observed2[i] == 0L) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, i);
            }
            obs1 = observed1[i];
            obs2 = observed2[i];
            dev = unequalCounts ? obs1 / weight - obs2 * weight : obs1 - obs2;
            sumSq += dev * dev / (obs1 + obs2);
        }
        return sumSq;
    }

    public double chiSquareTestDataSetsComparison(long[] observed1, long[] observed2) throws IllegalArgumentException, MathException {
        this.distribution.setDegreesOfFreedom((double)observed1.length - 1.0);
        return 1.0 - this.distribution.cumulativeProbability(this.chiSquareDataSetsComparison(observed1, observed2));
    }

    public boolean chiSquareTestDataSetsComparison(long[] observed1, long[] observed2, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, alpha, 0.0, 0.5);
        }
        return this.chiSquareTestDataSetsComparison(observed1, observed2) < alpha;
    }

    private void checkArray(long[][] in) throws IllegalArgumentException {
        if (in.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, in.length, 2);
        }
        if (in[0].length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, in[0].length, 2);
        }
        this.checkRectangular(in);
        this.checkNonNegative(in);
    }

    private void checkRectangular(long[][] in) {
        for (int i = 1; i < in.length; ++i) {
            if (in[i].length == in[0].length) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, in[i].length, in[0].length);
        }
    }

    private void checkPositive(double[] in) throws IllegalArgumentException {
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] <= 0.0)) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_ELEMENT_AT_INDEX, i, in[i]);
        }
    }

    private void checkNonNegative(long[] in) throws IllegalArgumentException {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] >= 0L) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, in[i]);
        }
    }

    private void checkNonNegative(long[][] in) throws IllegalArgumentException {
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[i].length; ++j) {
                if (in[i][j] >= 0L) continue;
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_2D_INDEX, i, j, in[i][j]);
            }
        }
    }

    public void setDistribution(ChiSquaredDistribution value) {
        this.distribution = value;
    }
}

