/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.maprminicluster;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.maprminicluster.MapRMiniDFSCluster;
import org.apache.hive.org.apache.commons.lang.StringUtils;

public class MapRMiniMrShim
implements HadoopShims.MiniMrShim {
    private final Configuration conf;
    private final MapRMiniDFSCluster mr;

    public MapRMiniMrShim() throws IOException {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.mr = new MapRMiniDFSCluster(this.conf);
    }

    public MapRMiniMrShim(Configuration conf) throws IOException {
        this.conf = conf;
        JobConf jConf = new JobConf(conf);
        jConf.set("yarn.scheduler.capacity.root.queues", "default");
        jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
        this.mr = new MapRMiniDFSCluster((Configuration)jConf);
    }

    @Override
    public int getJobTrackerPort() throws UnsupportedOperationException {
        String address = this.conf.get("yarn.resourcemanager.address");
        if (StringUtils.isBlank(address = StringUtils.substringAfterLast(address, ":"))) {
            throw new IllegalArgumentException("Invalid YARN resource manager port.");
        }
        return Integer.parseInt(address);
    }

    @Override
    public void shutdown() throws IOException {
        this.mr.shutdown();
    }

    @Override
    public void setupConfiguration(Configuration conf) {
        JobConf jConf = this.mr.createJobConf();
        for (Map.Entry pair : jConf) {
            conf.set((String)pair.getKey(), (String)pair.getValue());
        }
    }
}

