/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.lang;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hive.javolution.context.LogContext;
import org.apache.hive.javolution.lang.Reflection;

public class ClassInitializer {
    private ClassInitializer() {
    }

    public static void initializeAll() {
        ClassInitializer.initializeRuntime();
        ClassInitializer.initializeClassPath();
    }

    public static void initializeRuntime() {
        String bootPath = System.getProperty("sun.boot.class.path");
        String pathSeparator = System.getProperty("path.separator");
        if (bootPath == null || pathSeparator == null) {
            LogContext.warning("Cannot initialize boot path through system properties");
            return;
        }
        ClassInitializer.initialize(bootPath, pathSeparator);
        String javaHome = System.getProperty("java.home");
        String fileSeparator = System.getProperty("file.separator");
        if (javaHome == null || fileSeparator == null) {
            LogContext.warning("Cannot initialize extension library through system properties");
            return;
        }
        File extDir = new File(javaHome + fileSeparator + "lib" + fileSeparator + "ext");
        if (!extDir.getClass().getName().equals("java.io.File")) {
            LogContext.warning("Extension classes initialization not supported for J2ME build");
            return;
        }
        if (extDir.isDirectory()) {
            File[] files = extDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String path = files[i].getPath();
                if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                ClassInitializer.initializeJar(path);
            }
        } else {
            LogContext.warning(extDir + " is not a directory");
        }
    }

    public static void initializeClassPath() {
        String classPath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        if (classPath == null || pathSeparator == null) {
            LogContext.warning("Cannot initialize classpath through system properties");
            return;
        }
        ClassInitializer.initialize(classPath, pathSeparator);
    }

    private static void initialize(String classPath, String pathSeparator) {
        LogContext.info("Initialize classpath: " + classPath);
        while (classPath.length() > 0) {
            String name;
            int index = classPath.indexOf(pathSeparator);
            if (index < 0) {
                name = classPath;
                classPath = "";
            } else {
                name = classPath.substring(0, index);
                classPath = classPath.substring(index + pathSeparator.length());
            }
            if (name.endsWith(".jar") || name.endsWith(".zip")) {
                ClassInitializer.initializeJar(name);
                continue;
            }
            ClassInitializer.initializeDir(name);
        }
    }

    public static void initialize(Class cls) {
        try {
            Class.forName(cls.getName(), true, cls.getClassLoader());
            return;
        }
        catch (ClassNotFoundException e) {
            LogContext.error(e);
            return;
        }
    }

    public static void initialize(String className) {
        try {
            Class cls = Reflection.getInstance().getClass(className);
            if (cls == null) {
                LogContext.warning("Class + " + className + " not found");
            }
        }
        catch (Throwable error) {
            LogContext.error(error);
        }
    }

    public static void initializeJar(String jarName) {
        try {
            LogContext.info("Initialize Jar file: " + jarName);
            ZipFile jarFile = new ZipFile(jarName);
            if (!jarFile.getClass().getName().equals("java.util.zip.ZipFile")) {
                LogContext.warning("Initialization of classes in jar file not supported for J2ME build");
                return;
            }
            Enumeration<? extends ZipEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6);
                className = className.replace('/', '.');
                ClassInitializer.initialize(className);
            }
        }
        catch (Exception e) {
            LogContext.error(e);
        }
    }

    public static void initializeDir(String dirName) {
        LogContext.info("Initialize Directory: " + dirName);
        File file = new File(dirName);
        if (!file.getClass().getName().equals("java.io.File")) {
            LogContext.warning("Initialization of classes in directory not supported for J2ME build");
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ClassInitializer.initialize("", files[i]);
            }
        } else {
            LogContext.warning(dirName + " is not a directory");
        }
    }

    private static void initialize(String prefix, File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            String newPrefix = prefix.length() == 0 ? name : prefix + "." + name;
            for (int i = 0; i < files.length; ++i) {
                ClassInitializer.initialize(newPrefix, files[i]);
            }
        } else if (name.endsWith(".class")) {
            String className = prefix + "." + name.substring(0, name.length() - 6);
            ClassInitializer.initialize(className);
        }
    }
}

