/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http.security;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hive.http.security.PamUserIdentity;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PamLoginService
extends AbstractLifeCycle
implements LoginService {
    private final ConcurrentMap<String, UserIdentity> users = new ConcurrentHashMap<String, UserIdentity>();
    private IdentityService identityService = new DefaultIdentityService();
    private static final Logger LOG = Log.getLogger(PamLoginService.class);

    public String getName() {
        return "pam";
    }

    public UserIdentity login(String username, Object credentials) {
        Object user = (UserIdentity)this.users.get(username);
        if (user != null) {
            return user;
        }
        user = new PamUserIdentity(username);
        this.users.put(username, (UserIdentity)user);
        return user;
    }

    public boolean validate(UserIdentity user) {
        return this.users.containsKey(user.getUserPrincipal().getName());
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this.identityService = identityService;
    }

    public void logout(UserIdentity user) {
        this.users.remove(user.getUserPrincipal().getName());
        LOG.debug("logout {}", user);
    }
}

