/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.lmax.disruptor;

import java.util.concurrent.locks.LockSupport;
import org.apache.hive.com.lmax.disruptor.AlertException;
import org.apache.hive.com.lmax.disruptor.Sequence;
import org.apache.hive.com.lmax.disruptor.SequenceBarrier;
import org.apache.hive.com.lmax.disruptor.WaitStrategy;

public final class SleepingWaitStrategy
implements WaitStrategy {
    private static final int DEFAULT_RETRIES = 200;
    private final int retries;

    public SleepingWaitStrategy() {
        this(200);
    }

    public SleepingWaitStrategy(int retries) {
        this.retries = retries;
    }

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        int counter = this.retries;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            counter = this.applyWaitMethod(barrier, counter);
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(SequenceBarrier barrier, int counter) throws AlertException {
        barrier.checkAlert();
        if (counter > 100) {
            --counter;
        } else if (counter > 0) {
            --counter;
            Thread.yield();
        } else {
            LockSupport.parkNanos(1L);
        }
        return counter;
    }
}

