/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.beust.jcommander.converters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hive.com.beust.jcommander.ParameterException;
import org.apache.hive.com.beust.jcommander.converters.BaseConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISO8601DateConverter
extends BaseConverter<Date> {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public ISO8601DateConverter(String optionName) {
        super(optionName);
    }

    @Override
    public Date convert(String value) {
        try {
            return DATE_FORMAT.parse(value);
        }
        catch (ParseException pe) {
            throw new ParameterException(this.getErrorString(value, String.format("an ISO-8601 formatted date (%s)", DATE_FORMAT.toPattern())));
        }
    }
}

