/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
@SuppressWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="Yeah, its weird but its what we want")
public class JmxCacheBuster {
    private static final Log LOG = LogFactory.getLog(JmxCacheBuster.class);
    private static Object lock = new Object();
    private static ScheduledFuture fut = null;
    private static MetricsExecutor executor = new MetricsExecutorImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJmxCache() {
        Object object = lock;
        synchronized (object) {
            if (fut == null || !fut.isDone() && fut.getDelay(TimeUnit.MILLISECONDS) > 100L) {
                return;
            }
            fut = executor.getExecutor().schedule(new JmxCacheBusterRunnable(), 5L, TimeUnit.SECONDS);
        }
    }

    static class JmxCacheBusterRunnable
    implements Runnable {
        JmxCacheBusterRunnable() {
        }

        @Override
        public void run() {
            LOG.trace("Clearing JMX mbean cache.");
            try {
                if (DefaultMetricsSystem.instance() != null) {
                    DefaultMetricsSystem.instance().stop();
                    DefaultMetricsSystem.instance().start();
                }
            }
            catch (Exception exception) {
                LOG.debug("error clearing the jmx it appears the metrics system hasn't been started", exception);
            }
        }
    }
}

