/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenSelector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final boolean IBM_JAVA = System.getProperty("java.vendor").contains("IBM");
    public static final String XSRF_CUSTOM_HEADER_PARAM = "custom-header";
    public static final String XSRF_CUSTOM_METHODS_TO_IGNORE_PARAM = "methods-to-ignore";
    private static final String XSRF_HEADER_DEFAULT = "X-XSRF-HEADER";
    private static final Set<String> XSRF_METHODS_TO_IGNORE_DEFAULT = new HashSet<String>(Arrays.asList("GET", "OPTIONS", "HEAD", "TRACE"));

    public static UserGroupInformation getUGI() throws LoginException, IOException {
        String doAs = System.getenv("HADOOP_USER_NAME");
        if (doAs != null && doAs.length() > 0) {
            return UserGroupInformation.createProxyUser((String)doAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        return UserGroupInformation.getCurrentUser();
    }

    public static String getTokenStrForm(String tokenSignature) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenSelector tokenSelector = new DelegationTokenSelector();
        Token token = tokenSelector.selectToken(tokenSignature == null ? new Text() : new Text(tokenSignature), ugi.getTokens());
        return token != null ? token.encodeToUrlString() : null;
    }

    public static void setTokenStr(UserGroupInformation ugi, String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = Utils.createToken(tokenStr, tokenService);
        ugi.addToken(delegationToken);
    }

    public static String addServiceToToken(String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = Utils.createToken(tokenStr, tokenService);
        return delegationToken.encodeToUrlString();
    }

    private static Token<DelegationTokenIdentifier> createToken(String tokenStr, String tokenService) throws IOException {
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }

    public static void setZookeeperClientKerberosJaasConfig(String principal, String keyTabFile) throws IOException {
        String SASL_LOGIN_CONTEXT_NAME = "HiveZooKeeperClient";
        System.setProperty("zookeeper.sasl.clientconfig", "HiveZooKeeperClient");
        principal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        JaasConfiguration jaasConf = new JaasConfiguration("HiveZooKeeperClient", principal, keyTabFile);
        Configuration.setConfiguration(jaasConf);
    }

    public static Filter getXSRFFilter() {
        String filterClass = "org.apache.hadoop.security.http.RestCsrfPreventionFilter";
        try {
            Class<?> klass = Class.forName(filterClass);
            Filter f = (Filter)klass.newInstance();
            LOG.debug("Filter {} found, using as-is.", (Object)filterClass);
            return f;
        }
        catch (Exception e) {
            LOG.debug("Unable to use {}, got exception {}. Using internal shims impl of filter.", (Object)filterClass, (Object)e.getClass().getName());
            return Utils.constructXSRFFilter();
        }
    }

    private static Filter constructXSRFFilter() {
        return new Filter(){
            private String headerName = "X-XSRF-HEADER";
            private Set<String> methodsToIgnore = Utils.access$000();

            @Override
            public void init(FilterConfig filterConfig) throws ServletException {
                String customMethodsToIgnore;
                String customHeader = filterConfig.getInitParameter(Utils.XSRF_CUSTOM_HEADER_PARAM);
                if (customHeader != null) {
                    this.headerName = customHeader;
                }
                if ((customMethodsToIgnore = filterConfig.getInitParameter(Utils.XSRF_CUSTOM_METHODS_TO_IGNORE_PARAM)) != null) {
                    this.parseMethodsToIgnore(customMethodsToIgnore);
                }
            }

            void parseMethodsToIgnore(String mti) {
                String[] methods = mti.split(",");
                this.methodsToIgnore = new HashSet<String>();
                for (int i = 0; i < methods.length; ++i) {
                    this.methodsToIgnore.add(methods[i]);
                }
            }

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                if (Utils.doXsrfFilter(request, response, this.methodsToIgnore, this.headerName)) {
                    chain.doFilter(request, response);
                }
            }

            @Override
            public void destroy() {
            }
        };
    }

    public static boolean doXsrfFilter(ServletRequest request, ServletResponse response, Set<String> methodsToIgnore, String headerName) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (methodsToIgnore == null) {
            methodsToIgnore = XSRF_METHODS_TO_IGNORE_DEFAULT;
        }
        if (headerName == null) {
            headerName = XSRF_HEADER_DEFAULT;
        }
        if (methodsToIgnore.contains(httpRequest.getMethod()) || httpRequest.getHeader(headerName) != null) {
            return true;
        }
        ((HttpServletResponse)response).sendError(400, "Missing Required Header for Vulnerability Protection");
        response.getWriter().println("XSRF filter denial, requests must contain header : " + headerName);
        return false;
    }

    static /* synthetic */ Set access$000() {
        return XSRF_METHODS_TO_IGNORE_DEFAULT;
    }

    private static class JaasConfiguration
    extends Configuration {
        private static final boolean IBM_JAVA = System.getProperty("java.vendor").contains("IBM");
        private final Configuration baseConfig = Configuration.getConfiguration();
        private final String loginContextName;
        private final String principal;
        private final String keyTabFile;

        public JaasConfiguration(String hiveLoginContextName, String principal, String keyTabFile) {
            this.loginContextName = hiveLoginContextName;
            this.principal = principal;
            this.keyTabFile = keyTabFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                HashMap<String, String> krbOptions = new HashMap<String, String>();
                if (IBM_JAVA) {
                    krbOptions.put("credsType", "both");
                    krbOptions.put("useKeytab", this.keyTabFile);
                } else {
                    krbOptions.put("doNotPrompt", "true");
                    krbOptions.put("storeKey", "true");
                    krbOptions.put("useKeyTab", "true");
                    krbOptions.put("keyTab", this.keyTabFile);
                }
                krbOptions.put("principal", this.principal);
                krbOptions.put("refreshKrb5Config", "true");
                AppConfigurationEntry hiveZooKeeperClientEntry = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, krbOptions);
                return new AppConfigurationEntry[]{hiveZooKeeperClientEntry};
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }
    }
}

