/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.Hadoop23Shims;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.JobConf;

public class Hadoop20SUnifiedShims
extends Hadoop23Shims {
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;

    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        String taskLogURL = null;
        try {
            Class<?> taskLogClass = Class.forName("org.apache.hadoop.mapred.TaskLogServlet");
            Method taskLogMethod = taskLogClass.getDeclaredMethod("getTaskLogUrl", String.class, String.class, String.class);
            URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
            taskLogURL = (String)taskLogMethod.invoke(null, taskTrackerHttpURL.getHost(), Integer.toString(taskTrackerHttpURL.getPort()), taskAttemptId);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error trying to get task log URL", e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (IllegalAccessException e) {
            LOG.error("Error trying to get task log URL", e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (InvocationTargetException e) {
            LOG.error("Error trying to get task log URL", e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (SecurityException e) {
            LOG.error("Error trying to get task log URL", e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (NoSuchMethodException e) {
            LOG.error("Error trying to get task log URL", e);
            throw new MalformedURLException("Method getTaskLogUrl not found: " + e.getCause());
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Can't fetch tasklog: TaskLogServlet is not found in unified hadoop API.");
        }
        return taskLogURL;
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        return "local".equals(this.getJobLauncherRpcAddress(conf));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("mapred.job.tracker");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        conf.set("mapred.job.tracker", val);
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("mapred.job.tracker.http.address");
    }

    @Override
    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims20SUnified();
        }
        return this.hcatShimInstance;
    }

    private final class HCatHadoopShims20SUnified
    extends Hadoop23Shims.HCatHadoopShims23 {
        private HCatHadoopShims20SUnified() {
        }

        @Override
        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapred.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapred.cache.archives";
                }
                case CACHE_SYMLINK: {
                    return "mapred.create.symlink";
                }
            }
            return "";
        }
    }
}

