/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.log;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginNode;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="LlapWrappedAppender", category="Core", elementType="appender", printObject=true, deferChildren=true)
public class LlapWrappedAppender
extends AbstractAppender {
    private static final boolean DEFAULT_RENAME_FILES_ON_CLOSE = true;
    private static final String DEFAULT_RENAMED_FILE_SUFFIX = ".done";
    private final Node node;
    private final Configuration config;
    private final boolean renameFileOnClose;
    private final String renamedFileSuffix;
    private AtomicReference<Appender> realAppender = new AtomicReference();
    private AtomicReference<AppenderControl> appenderControl = new AtomicReference();

    public LlapWrappedAppender(String name, Node node, Configuration config, boolean renameOnClose, String renamedFileSuffix) {
        super(name, null, null);
        this.node = node;
        this.config = config;
        this.renameFileOnClose = renameOnClose;
        this.renamedFileSuffix = renamedFileSuffix;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LlapWrappedAppender.class.getName() + " created with name=" + name + ", renameOnClose=" + renameOnClose + ", renamedFileSuffix=" + renamedFileSuffix);
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void append(LogEvent event) {
        this.setupAppenderIfRequired(event);
        if (this.appenderControl.get() != null) {
            if (event.getMarker() == null || event.getMarker().getName() == null || !event.getMarker().getName().equals("EOF_MARKER")) {
                this.appenderControl.get().callAppender(event);
            } else {
                LOGGER.debug("Not forwarding message with maker={}, marker.getName={}", (Object)event.getMarker(), (Object)(event.getMarker() == null ? "nullMarker" : event.getMarker().getName()));
            }
        }
    }

    private void setupAppenderIfRequired(LogEvent event) {
        if (this.appenderControl.get() == null) {
            if (this.node.getType().getElementName().equalsIgnoreCase("appender")) {
                for (Node cnode : this.node.getChildren()) {
                    Node appNode = new Node(cnode);
                    this.config.createConfiguration(appNode, event);
                    if (!(appNode.getObject() instanceof Appender)) continue;
                    Appender app = (Appender)appNode.getObject();
                    app.start();
                    if (!(app instanceof RandomAccessFileAppender)) {
                        String message = "Cannot handle appenders other than " + RandomAccessFileAppender.class.getName() + ". Found: " + app.getClass().getName();
                        LOGGER.error(message);
                        throw new IllegalStateException(message);
                    }
                    this.realAppender.set(app);
                    this.appenderControl.set(new AppenderControl(app, null, null));
                    if (!LOGGER.isDebugEnabled()) break;
                    RandomAccessFileAppender raf = (RandomAccessFileAppender)app;
                    LOGGER.debug("Setup new appender to write to file: " + raf.getFileName() + ", appenderName=" + raf.getName() + ", appenderManagerName=" + ((RandomAccessFileManager)raf.getManager()).getName());
                    break;
                }
                if (this.appenderControl.get() == null) {
                    throw new RuntimeException(LlapWrappedAppender.class.getSimpleName() + "name=" + this.getName() + " unable to setup actual appender.Could not find child appender");
                }
            } else {
                throw new RuntimeException(LlapWrappedAppender.class.getSimpleName() + "name=" + this.getName() + " unable to setup actual appender.Could not find child appender");
            }
        }
    }

    @Override
    public void stop() {
        if (!this.isStopping() && !this.isStopped()) {
            super.stop();
            if (this.appenderControl.get() != null) {
                this.appenderControl.get().stop();
                this.realAppender.get().stop();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stop invoked for " + ((RandomAccessFileAppender)this.realAppender.get()).getFileName());
            }
            if (this.realAppender.get() == null) {
                LOGGER.info("RealAppender is null. Ignoring stop");
                return;
            }
            RandomAccessFileAppender raf = (RandomAccessFileAppender)this.realAppender.get();
            Path renamedPath = null;
            if (this.renameFileOnClose) {
                try {
                    int counter = 0;
                    while (true) {
                        if (!Files.exists(renamedPath = this.getRenamedPath(raf.getFileName(), counter), new LinkOption[0])) {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Renaming file: " + raf.getFileName() + " to " + renamedPath);
                            }
                            Files.move(Paths.get(raf.getFileName(), new String[0]), renamedPath, new CopyOption[0]);
                            break;
                        }
                        ++counter;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to rename file: " + raf.getFileName() + " to " + renamedPath, (Throwable)e);
                }
            }
        }
    }

    private Path getRenamedPath(String originalFileName, int iteration) {
        Path renamedPath = iteration == 0 ? Paths.get(originalFileName + this.renamedFileSuffix, new String[0]) : Paths.get(originalFileName + "." + iteration + this.renamedFileSuffix, new String[0]);
        return renamedPath;
    }

    @PluginFactory
    public static LlapWrappedAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="renameFileOnClose") String renameFileOnCloseProvided, @PluginAttribute(value="renamedFileSuffix") String renamedFileSuffixProvided, @PluginNode Node node, @PluginConfiguration Configuration config) {
        if (config == null) {
            LOGGER.error("PluginConfiguration not expected to be null");
            return null;
        }
        if (node == null) {
            LOGGER.error("Node must be specified as an appender specification");
            return null;
        }
        boolean renameFileOnClose = true;
        if (Strings.isNotBlank(renameFileOnCloseProvided)) {
            renameFileOnClose = Boolean.parseBoolean(renameFileOnCloseProvided);
        }
        String renamedFileSuffix = DEFAULT_RENAMED_FILE_SUFFIX;
        if (Strings.isNotBlank(renamedFileSuffixProvided)) {
            renamedFileSuffix = renamedFileSuffixProvided;
        }
        return new LlapWrappedAppender(name, node, config, renameFileOnClose, renamedFileSuffix);
    }
}

