/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.StorageUtils;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Joiner;
import org.apache.hive.com.google.common.base.Objects;
import org.apache.hive.com.google.common.base.Predicate;
import org.apache.hive.com.google.common.collect.Iterables;
import org.apache.hive.org.apache.commons.lang.ArrayUtils;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public class HdfsUtils {
    private static final Logger LOG = LoggerFactory.getLogger("shims.HdfsUtils");
    private static final String HDFS_ID_PATH_PREFIX = "/.reserved/.inodes/";

    public static Path getFileIdPath(FileSystem fileSystem, Path path, long fileId) {
        return fileSystem instanceof DistributedFileSystem ? new Path(HDFS_ID_PATH_PREFIX + fileId) : path;
    }

    public static void setFullFileStatus(Configuration conf, HadoopFileStatus sourceStatus, FileSystem fs, Path target, boolean recursion) {
        if (StorageUtils.shouldSetPerms(conf, fs)) {
            HdfsUtils.setFullFileStatus(conf, sourceStatus, null, fs, target, recursion, true);
        }
    }

    public static void setFullFileStatus(Configuration conf, HadoopFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursion) {
        HdfsUtils.setFullFileStatus(conf, sourceStatus, targetGroup, fs, target, recursion, true);
    }

    public static void setFullFileStatus(Configuration conf, HadoopFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursion, boolean isDir) {
        if (StorageUtils.shouldSetPerms(conf, fs)) {
            HdfsUtils.setFullFileStatus(conf, sourceStatus, targetGroup, fs, target, recursion, recursion ? new FsShell() : null, isDir);
        }
    }

    @VisibleForTesting
    static void setFullFileStatus(Configuration conf, HadoopFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursion, FsShell fsShell) {
        HdfsUtils.setFullFileStatus(conf, sourceStatus, targetGroup, fs, target, recursion, fsShell, true);
    }

    @VisibleForTesting
    static void setFullFileStatus(Configuration conf, HadoopFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursion, FsShell fsShell, boolean isDir) {
        try {
            FileStatus fStatus = sourceStatus.getFileStatus();
            String group = fStatus.getGroup();
            boolean aclEnabled = Objects.equal(conf.get("dfs.namenode.acls.enabled"), "true");
            FsPermission sourcePerm = fStatus.getPermission();
            ArrayList<AclEntry> aclEntries = null;
            if (aclEnabled && sourceStatus.getAclEntries() != null && !sourceStatus.getAclEntries().isEmpty()) {
                LOG.trace(sourceStatus.getAclStatus().toString());
                List<AclEntry> defaults = HdfsUtils.extractDefaultAcls(sourceStatus.getAclEntries());
                if (!defaults.isEmpty()) {
                    aclEntries = new ArrayList<AclEntry>(defaults.size() * 2);
                    for (AclEntry acl : defaults) {
                        if (acl.getType() == AclEntryType.OTHER) {
                            aclEntries.add(HdfsUtils.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
                            continue;
                        }
                        aclEntries.add(HdfsUtils.newAclEntry(AclEntryScope.ACCESS, acl.getType(), acl.getName(), acl.getPermission()));
                    }
                    if (isDir) {
                        aclEntries.addAll(defaults);
                    }
                } else {
                    FsAction groupAction = null;
                    for (AclEntry acl : sourceStatus.getAclEntries()) {
                        if (acl.getType() != AclEntryType.GROUP) continue;
                        groupAction = acl.getPermission();
                        break;
                    }
                    aclEntries = new ArrayList(3);
                    aclEntries.add(HdfsUtils.newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, sourcePerm.getUserAction()));
                    aclEntries.add(HdfsUtils.newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, groupAction));
                    aclEntries.add(HdfsUtils.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
                }
            }
            if (recursion) {
                fsShell.setConf(conf);
                if (group != null && !group.isEmpty()) {
                    HdfsUtils.run(fsShell, new String[]{"-chgrp", "-R", group, target.toString()});
                }
                if (aclEntries != null) {
                    try {
                        String aclEntry = Joiner.on(",").join(aclEntries);
                        HdfsUtils.run(fsShell, new String[]{"-setfacl", "-R", "--set", aclEntry, target.toString()});
                    }
                    catch (Exception e) {
                        LOG.info("Skipping ACL inheritance: File system for path " + target + " does not support ACLs but dfs.namenode.acls.enabled is set to true. ");
                        LOG.debug("The details are: " + e, e);
                    }
                } else {
                    String permission = Integer.toString(sourcePerm.toShort(), 8);
                    HdfsUtils.run(fsShell, new String[]{"-chmod", "-R", permission, target.toString()});
                }
            } else {
                if (!(group == null || group.isEmpty() || targetGroup != null && group.equals(targetGroup))) {
                    fs.setOwner(target, null, group);
                }
                if (aclEntries != null) {
                    fs.setAcl(target, aclEntries);
                } else {
                    fs.setPermission(target, sourcePerm);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to inherit permissions for file " + target + " from file " + sourceStatus.getFileStatus().getPath(), (Object)e.getMessage());
            LOG.debug("Exception while inheriting permissions", e);
        }
    }

    private static AclEntry newAclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return HdfsUtils.newAclEntry(scope, type, null, permission);
    }

    private static AclEntry newAclEntry(AclEntryScope scope, AclEntryType type, String name, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).setPermission(permission).build();
    }

    private static List<AclEntry> extractDefaultAcls(List<AclEntry> acls) {
        ArrayList<AclEntry> defaults = new ArrayList<AclEntry>(acls);
        Iterables.removeIf(defaults, new Predicate<AclEntry>(){

            @Override
            public boolean apply(AclEntry acl) {
                return !acl.getScope().equals((Object)AclEntryScope.DEFAULT);
            }
        });
        return defaults;
    }

    private static void run(FsShell shell, String[] command) throws Exception {
        LOG.debug(ArrayUtils.toString(command));
        int retval = shell.run(command);
        LOG.debug("Return value is :" + retval);
    }

    public static void setParentFileStatus(Configuration conf, FileSystem fs, Path destPath, boolean recursive) throws IOException {
        HdfsUtils.setFullFileStatus(conf, new HadoopFileStatus(conf, fs, destPath.getParent()), fs, destPath, recursive);
    }

    public static class HadoopFileStatus {
        private final FileStatus fileStatus;
        private final AclStatus aclStatus;

        public HadoopFileStatus(Configuration conf, FileSystem fs, Path file) throws IOException {
            FileStatus fileStatus = fs.getFileStatus(file);
            AclStatus aclStatus = null;
            if (Objects.equal(conf.get("dfs.namenode.acls.enabled"), "true")) {
                try {
                    aclStatus = fs.getAclStatus(file);
                }
                catch (Exception e) {
                    LOG.info("Skipping ACL inheritance: File system for path " + file + " does not support ACLs but dfs.namenode.acls.enabled is set to true. ");
                    LOG.debug("The details are: " + e, e);
                }
            }
            this.fileStatus = fileStatus;
            this.aclStatus = aclStatus;
        }

        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        public List<AclEntry> getAclEntries() {
            return this.aclStatus == null ? null : Collections.unmodifiableList(this.aclStatus.getEntries());
        }

        @VisibleForTesting
        AclStatus getAclStatus() {
            return this.aclStatus;
        }
    }
}

