/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.SystemVariables;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public class VariableSubstitution
extends SystemVariables {
    private static final Logger l4j = LoggerFactory.getLogger(VariableSubstitution.class);
    private final HiveVariableSource hiveVariableSource;

    public VariableSubstitution(HiveVariableSource hiveVariableSource) {
        this.hiveVariableSource = hiveVariableSource;
    }

    @Override
    protected String getSubstitute(Configuration conf, String var) {
        String val = super.getSubstitute(conf, var);
        if (val == null && this.hiveVariableSource != null) {
            Map<String, String> vars = this.hiveVariableSource.getHiveVariable();
            val = var.startsWith("hivevar:") ? vars.get(var.substring("hivevar:".length())) : vars.get(var);
        }
        return val;
    }

    public String substitute(HiveConf conf, String expr) {
        if (expr == null) {
            return expr;
        }
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEVARIABLESUBSTITUTE)) {
            return expr;
        }
        l4j.debug("Substitution is on: " + expr);
        int depth = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVEVARIABLESUBSTITUTEDEPTH);
        return this.substitute(conf, expr, depth);
    }
}

