/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKTableStateManager
implements TableStateManager {
    private static final Log LOG = LogFactory.getLog(ZKTableStateManager.class);
    private final ZooKeeperWatcher watcher;
    private final Map<TableName, ZooKeeperProtos.Table.State> cache = new HashMap<TableName, ZooKeeperProtos.Table.State>();

    public ZKTableStateManager(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        this.watcher = zkw;
        this.populateTableStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableStates() throws KeeperException, InterruptedException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            List<String> children = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.tableZNode);
            if (children == null) {
                return;
            }
            for (String child : children) {
                TableName tableName = TableName.valueOf(child);
                ZooKeeperProtos.Table.State state = this.getTableState(this.watcher, tableName);
                if (state == null) continue;
                this.cache.put(tableName, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTableState(TableName tableName, ZooKeeperProtos.Table.State state) throws CoordinatedStateException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            LOG.info("Moving table " + tableName + " state from " + (Object)((Object)this.cache.get(tableName)) + " to " + (Object)((Object)state));
            try {
                this.setTableStateInZK(tableName, state);
            }
            catch (KeeperException e) {
                throw new CoordinatedStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTableStateIfInStates(TableName tableName, ZooKeeperProtos.Table.State newState, ZooKeeperProtos.Table.State ... states) throws CoordinatedStateException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (newState == ZooKeeperProtos.Table.State.DISABLING && this.cache.get(tableName) != null && !this.isTableState(tableName, states) || newState != ZooKeeperProtos.Table.State.DISABLING && !this.isTableState(tableName, states)) {
                return false;
            }
            try {
                this.setTableStateInZK(tableName, newState);
            }
            catch (KeeperException e) {
                throw new CoordinatedStateException(e);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTableStateIfNotInStates(TableName tableName, ZooKeeperProtos.Table.State newState, ZooKeeperProtos.Table.State ... states) throws CoordinatedStateException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.isTableState(tableName, states)) {
                try {
                    ZooKeeperProtos.Table.State curstate = this.getTableState(this.watcher, tableName);
                    if (this.isTableInState(Arrays.asList(states), curstate)) {
                        return false;
                    }
                }
                catch (KeeperException e) {
                    throw new CoordinatedStateException(e);
                }
                catch (InterruptedException e) {
                    throw new CoordinatedStateException(e);
                }
            }
            try {
                this.setTableStateInZK(tableName, newState);
            }
            catch (KeeperException e) {
                throw new CoordinatedStateException(e);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableStateInZK(TableName tableName, ZooKeeperProtos.Table.State state) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.watcher.tableZNode, tableName.getNameAsString());
        if (ZKUtil.checkExists(this.watcher, znode) == -1) {
            ZKUtil.createAndFailSilent(this.watcher, znode);
        }
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            builder.setState(state);
            byte[] data = ProtobufUtil.prependPBMagic(builder.build().toByteArray());
            ZKUtil.setData(this.watcher, znode, data);
            this.cache.put(tableName, state);
        }
    }

    @Override
    public boolean isTableState(TableName tableName, ZooKeeperProtos.Table.State ... states) {
        return this.isTableState(tableName, false, states);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableState(TableName tableName, boolean checkSource, ZooKeeperProtos.Table.State ... states) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.State currentState = this.cache.get(tableName);
            if (checkSource) {
                try {
                    ZooKeeperProtos.Table.State stateInZK = this.getTableState(this.watcher, tableName);
                    if (currentState != stateInZK) {
                        if (stateInZK != null) {
                            this.cache.put(tableName, stateInZK);
                        } else {
                            this.cache.remove(tableName);
                        }
                        currentState = stateInZK;
                    }
                }
                catch (InterruptedException | KeeperException e) {
                    // empty catch block
                }
            }
            return this.isTableInState(Arrays.asList(states), currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeletedTable(TableName tableName) throws CoordinatedStateException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.cache.remove(tableName) == null) {
                LOG.warn("Moving table " + tableName + " state to deleted but was already deleted");
            }
            try {
                ZKUtil.deleteNodeFailSilent(this.watcher, ZKUtil.joinZNode(this.watcher.tableZNode, tableName.getNameAsString()));
            }
            catch (KeeperException e) {
                throw new CoordinatedStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTablePresent(TableName tableName) {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.State state = this.cache.get(tableName);
            return state != null;
        }
    }

    @Override
    public Set<TableName> getTablesInStates(ZooKeeperProtos.Table.State ... states) throws InterruptedIOException, CoordinatedStateException {
        try {
            return this.getAllTables(states);
        }
        catch (KeeperException e) {
            throw new CoordinatedStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAndRemoveTableState(TableName tableName, ZooKeeperProtos.Table.State states, boolean deletePermanentState) throws CoordinatedStateException {
        Map<TableName, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.isTableState(tableName, states)) {
                this.cache.remove(tableName);
                if (deletePermanentState) {
                    try {
                        ZKUtil.deleteNodeFailSilent(this.watcher, ZKUtil.joinZNode(this.watcher.tableZNode, tableName.getNameAsString()));
                    }
                    catch (KeeperException e) {
                        throw new CoordinatedStateException(e);
                    }
                }
            }
        }
    }

    Set<TableName> getAllTables(ZooKeeperProtos.Table.State ... states) throws KeeperException, InterruptedIOException {
        HashSet<TableName> allTables = new HashSet<TableName>();
        List<String> children = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.tableZNode);
        if (children == null) {
            return allTables;
        }
        block2: for (String child : children) {
            ZooKeeperProtos.Table.State state;
            TableName tableName = TableName.valueOf(child);
            try {
                state = this.getTableState(this.watcher, tableName);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            for (ZooKeeperProtos.Table.State expectedState : states) {
                if (state != expectedState) continue;
                allTables.add(tableName);
                continue block2;
            }
        }
        return allTables;
    }

    private ZooKeeperProtos.Table.State getTableState(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        String znode = ZKUtil.joinZNode(zkw.tableZNode, tableName.getNameAsString());
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix(data);
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.Table t = ((ZooKeeperProtos.Table.Builder)builder.mergeFrom(data, magicLen, data.length - magicLen)).build();
            return t.getState();
        }
        catch (InvalidProtocolBufferException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    private boolean isTableInState(List<ZooKeeperProtos.Table.State> expectedStates, ZooKeeperProtos.Table.State currentState) {
        return currentState != null && expectedStates.contains((Object)currentState);
    }
}

