/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DefaultWALProvider
implements WALProvider {
    private static final Log LOG = LogFactory.getLog(DefaultWALProvider.class);
    private FSHLog log = null;
    public static final String WAL_FILE_NAME_DELIMITER = ".";
    @VisibleForTesting
    public static final String META_WAL_PROVIDER_ID = ".meta";
    static final String DEFAULT_PROVIDER_ID = "default";
    public static final String SPLITTING_EXT = "-splitting";
    private static final Pattern pattern = Pattern.compile(".*\\.\\d*(.meta)*");

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        if (null != this.log) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        if (null == providerId) {
            providerId = DEFAULT_PROVIDER_ID;
        }
        String logPrefix = factory.factoryId + WAL_FILE_NAME_DELIMITER + providerId;
        this.log = new FSHLog(FileSystem.get((Configuration)conf), FSUtils.getRootDir(conf), DefaultWALProvider.getWALDirectoryName(factory.factoryId), "oldWALs", conf, listeners, true, logPrefix, META_WAL_PROVIDER_ID.equals(providerId) ? META_WAL_PROVIDER_ID : null);
    }

    @Override
    public WAL getWAL(byte[] identifier) throws IOException {
        return this.log;
    }

    @Override
    public void close() throws IOException {
        this.log.close();
    }

    @Override
    public void shutdown() throws IOException {
        this.log.shutdown();
    }

    public static long getNumLogFiles(WALFactory walFactory) {
        WALProvider meta;
        long result = 0L;
        if (walFactory.provider instanceof DefaultWALProvider) {
            result += (long)((DefaultWALProvider)walFactory.provider).log.getNumLogFiles();
        }
        if ((meta = walFactory.metaProvider.get()) instanceof DefaultWALProvider) {
            result += (long)((DefaultWALProvider)meta).log.getNumLogFiles();
        }
        return result;
    }

    public static long getLogFileSize(WALFactory walFactory) {
        WALProvider meta;
        long result = 0L;
        if (walFactory.provider instanceof DefaultWALProvider) {
            result += ((DefaultWALProvider)walFactory.provider).log.getLogFileSize();
        }
        if ((meta = walFactory.metaProvider.get()) instanceof DefaultWALProvider) {
            result += ((DefaultWALProvider)meta).log.getLogFileSize();
        }
        return result;
    }

    @VisibleForTesting
    public static int getNumRolledLogFiles(WAL wal) {
        return ((FSHLog)wal).getNumRolledLogFiles();
    }

    @VisibleForTesting
    public static Path getCurrentFileName(WAL wal) {
        return ((FSHLog)wal).getCurrentFileName();
    }

    @VisibleForTesting
    static void requestLogRoll(WAL wal) {
        ((FSHLog)wal).requestLogRoll();
    }

    @VisibleForTesting
    public static long extractFileNumFromWAL(WAL wal) {
        Path walName = ((FSHLog)wal).getCurrentFileName();
        if (walName == null) {
            throw new IllegalArgumentException("The WAL path couldn't be null");
        }
        String[] walPathStrs = walName.toString().split("\\.");
        return Long.parseLong(walPathStrs[walPathStrs.length - (DefaultWALProvider.isMetaFile(walName) ? 2 : 1)]);
    }

    public static boolean validateWALFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    public static String getWALDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder("WALs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    public static ServerName getServerNameFromWALDirectoryName(Configuration conf, String path) throws IOException {
        String fullPath;
        if (path == null || path.length() <= "WALs".length()) {
            return null;
        }
        if (conf == null) {
            throw new IllegalArgumentException("parameter conf must be set");
        }
        String rootDir = conf.get("hbase.rootdir");
        if (rootDir == null || rootDir.isEmpty()) {
            throw new IllegalArgumentException("hbase.rootdir key not found in conf.");
        }
        StringBuilder startPathSB = new StringBuilder(rootDir);
        if (!rootDir.endsWith("/")) {
            startPathSB.append('/');
        }
        startPathSB.append("WALs");
        if (!"WALs".endsWith("/")) {
            startPathSB.append('/');
        }
        String startPath = startPathSB.toString();
        try {
            fullPath = FileSystem.get((Configuration)conf).makeQualified(new Path(path)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info("Call to makeQualified failed on " + path + " " + e.getMessage());
            return null;
        }
        if (!fullPath.startsWith(startPath)) {
            return null;
        }
        String serverNameAndFile = fullPath.substring(startPath.length());
        if (serverNameAndFile.indexOf(47) < "a,0,0".length()) {
            return null;
        }
        Path p = new Path(path);
        return DefaultWALProvider.getServerNameFromWALDirectoryName(p);
    }

    public static ServerName getServerNameFromWALDirectoryName(Path logFile) {
        String logDirName = logFile.getParent().getName();
        if (logDirName.equals("WALs")) {
            logDirName = logFile.getName();
        }
        ServerName serverName = null;
        if (logDirName.endsWith(SPLITTING_EXT)) {
            logDirName = logDirName.substring(0, logDirName.length() - SPLITTING_EXT.length());
        }
        try {
            serverName = ServerName.parseServerName(logDirName);
        }
        catch (IllegalArgumentException ex) {
            serverName = null;
            LOG.warn("Cannot parse a server name from path=" + logFile + "; " + ex.getMessage());
        }
        if (serverName != null && serverName.getStartcode() < 0L) {
            LOG.warn("Invalid log file path=" + logFile);
            serverName = null;
        }
        return serverName;
    }

    public static boolean isMetaFile(Path p) {
        return DefaultWALProvider.isMetaFile(p.getName());
    }

    public static boolean isMetaFile(String p) {
        return p != null && p.endsWith(META_WAL_PROVIDER_ID);
    }

    public static Writer createWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable) throws IOException {
        Class logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, Writer.class);
        try {
            Writer writer = (Writer)logWriterClass.newInstance();
            writer.init(fs, path, conf, overwritable);
            return writer;
        }
        catch (Exception e) {
            LOG.debug("Error instantiating log writer.", e);
            throw new IOException("cannot get log writer", e);
        }
    }

    public static interface Writer
    extends WALProvider.Writer {
        public void init(FileSystem var1, Path var2, Configuration var3, boolean var4) throws IOException;
    }

    public static interface Reader
    extends WAL.Reader {
        public void init(FileSystem var1, Path var2, Configuration var3, FSDataInputStream var4) throws IOException;
    }
}

