/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.util.Arrays;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOfflineMetaRebuildBase
extends OfflineMetaRebuildTestCore {
    @Test(timeout=120000L)
    public void testMetaRebuild() throws Exception {
        this.wipeOutMeta();
        Assert.assertEquals((long)1L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertTrue((boolean)fsck.rebuildMeta(false));
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        try (Connection connection = ConnectionFactory.createConnection(this.TEST_UTIL.getConfiguration());){
            Admin admin = connection.getAdmin();
            admin.enableTable(this.table);
            LOG.info("Waiting for no more RIT");
            this.TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            LOG.info("No more RIT in ZK, now doing final test verification");
            Assert.assertEquals((long)5L, (long)this.scanMeta());
            Object[] htbls = admin.listTables();
            LOG.info("Tables present after restart: " + Arrays.toString(htbls));
            Assert.assertEquals((long)1L, (long)htbls.length);
        }
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
        LOG.info("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries.");
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
    }
}

