/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Iterator;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.SortedCopyOnWriteSet;
import org.apache.hive.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSortedCopyOnWriteSet {
    @Test
    public void testSorting() throws Exception {
        SortedCopyOnWriteSet<String> set = new SortedCopyOnWriteSet<String>();
        set.add("c");
        set.add("d");
        set.add("a");
        set.add("b");
        Object[] expected = new String[]{"a", "b", "c", "d"};
        Object[] stored = set.toArray(new String[4]);
        Assert.assertArrayEquals((Object[])expected, (Object[])stored);
        set.add("c");
        Assert.assertEquals((long)4L, (long)set.size());
        stored = set.toArray(new String[4]);
        Assert.assertArrayEquals((Object[])expected, (Object[])stored);
    }

    @Test
    public void testIteratorIsolation() throws Exception {
        String next;
        SortedCopyOnWriteSet<String> set = new SortedCopyOnWriteSet<String>(Lists.newArrayList("a", "b", "c", "d", "e"));
        Iterator<String> iter = set.iterator();
        set.remove("c");
        boolean found = false;
        while (iter.hasNext() && !found) {
            found = "c".equals(iter.next());
        }
        Assert.assertTrue((boolean)found);
        iter = set.iterator();
        found = false;
        while (iter.hasNext() && !found) {
            found = "c".equals(iter.next());
        }
        Assert.assertFalse((boolean)found);
        iter = set.iterator();
        set.add("f");
        found = false;
        while (iter.hasNext() && !found) {
            next = iter.next();
            found = "f".equals(next);
        }
        Assert.assertFalse((boolean)found);
        iter = set.iterator();
        set.addAll(Lists.newArrayList("g", "h", "i"));
        found = false;
        while (iter.hasNext() && !found) {
            next = iter.next();
            found = "g".equals(next) || "h".equals(next) || "i".equals(next);
        }
        Assert.assertFalse((boolean)found);
        iter = set.iterator();
        set.clear();
        Assert.assertEquals((long)0L, (long)set.size());
        int size = 0;
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
    }
}

