/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFSTableDescriptors {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestFSTableDescriptors.class);

    @Test(expected=IllegalArgumentException.class)
    public void testRegexAgainstOldStyleTableInfo() {
        Path p = new Path("/tmp", ".tableinfo");
        int i = FSTableDescriptors.getTableInfoSequenceId(p);
        Assert.assertEquals((long)0L, (long)i);
        p = new Path("/tmp", "abc");
        FSTableDescriptors.getTableInfoSequenceId(p);
    }

    @Test
    public void testCreateAndUpdate() throws IOException {
        Path testdir = UTIL.getDataTestDir("testCreateAndUpdate");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testCreate"));
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, testdir);
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Assert.assertFalse((boolean)fstd.createTableDescriptor(htd));
        FileStatus[] statuses = fs.listStatus(testdir);
        Assert.assertTrue((String)("statuses.length=" + statuses.length), (statuses.length == 1 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            fstd.updateTableDescriptor(htd);
        }
        statuses = fs.listStatus(testdir);
        Assert.assertTrue((statuses.length == 1 ? 1 : 0) != 0);
        Path tmpTableDir = new Path(FSUtils.getTableDir(testdir, htd.getTableName()), ".tmp");
        statuses = fs.listStatus(tmpTableDir);
        Assert.assertTrue((statuses.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSequenceIdAdvancesOnTableInfo() throws IOException {
        Path testdir = UTIL.getDataTestDir("testSequenceidAdvancesOnTableInfo");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testSequenceidAdvancesOnTableInfo"));
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, testdir);
        Path p0 = fstd.updateTableDescriptor(htd);
        int i0 = FSTableDescriptors.getTableInfoSequenceId(p0);
        Path p1 = fstd.updateTableDescriptor(htd);
        Assert.assertTrue((!fs.exists(p0) ? 1 : 0) != 0);
        int i1 = FSTableDescriptors.getTableInfoSequenceId(p1);
        Assert.assertTrue((i1 == i0 + 1 ? 1 : 0) != 0);
        Path p2 = fstd.updateTableDescriptor(htd);
        Assert.assertTrue((!fs.exists(p1) ? 1 : 0) != 0);
        int i2 = FSTableDescriptors.getTableInfoSequenceId(p2);
        Assert.assertTrue((i2 == i1 + 1 ? 1 : 0) != 0);
    }

    @Test
    public void testFormatTableInfoSequenceId() {
        Path p0 = this.assertWriteAndReadSequenceId(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append("0");
        }
        Assert.assertEquals((Object)(".tableinfo." + sb.toString()), (Object)p0.getName());
        Path p2 = this.assertWriteAndReadSequenceId(2);
        Path p10000 = this.assertWriteAndReadSequenceId(10000);
        Path p = new Path(p0.getParent(), ".tableinfo");
        FileStatus fs = new FileStatus(0L, false, 0, 0L, 0L, p);
        FileStatus fs0 = new FileStatus(0L, false, 0, 0L, 0L, p0);
        FileStatus fs2 = new FileStatus(0L, false, 0, 0L, 0L, p2);
        FileStatus fs10000 = new FileStatus(0L, false, 0, 0L, 0L, p10000);
        Comparator<FileStatus> comparator = FSTableDescriptors.TABLEINFO_FILESTATUS_COMPARATOR;
        Assert.assertTrue((comparator.compare(fs, fs0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs0, fs2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs2, fs10000) > 0 ? 1 : 0) != 0);
    }

    private Path assertWriteAndReadSequenceId(int i) {
        Path p = new Path("/tmp", FSTableDescriptors.getTableInfoFileName(i));
        int ii = FSTableDescriptors.getTableInfoSequenceId(p);
        Assert.assertEquals((long)i, (long)ii);
        return p;
    }

    @Test
    public void testRemoves() throws IOException {
        String name = "testRemoves";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testRemoves");
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testRemoves"));
        htds.add(htd);
        Assert.assertNotNull((Object)htds.remove(htd.getTableName()));
        Assert.assertNull((Object)htds.remove(htd.getTableName()));
    }

    @Test
    public void testReadingHTDFromFS() throws IOException {
        String name = "testReadingHTDFromFS";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testReadingHTDFromFS"));
        Path rootdir = UTIL.getDataTestDir("testReadingHTDFromFS");
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        fstd.createTableDescriptor(htd);
        HTableDescriptor htd2 = FSTableDescriptors.getTableDescriptorFromFs(fs, rootdir, htd.getTableName());
        Assert.assertTrue((boolean)htd.equals(htd2));
    }

    @Test
    public void testHTableDescriptors() throws IOException, InterruptedException {
        HTableDescriptor htd;
        int i;
        String name = "testHTableDescriptors";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testHTableDescriptors");
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(fs, rootdir);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            htd = new HTableDescriptor("testHTableDescriptors" + i);
            htds.createTableDescriptor(htd);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((((FSTableDescriptors)htds).get(TableName.valueOf("testHTableDescriptors" + i)) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((((FSTableDescriptors)htds).get(TableName.valueOf("testHTableDescriptors" + i)) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            htd = new HTableDescriptor(TableName.valueOf("testHTableDescriptors" + i));
            htd.addFamily(new HColumnDescriptor("" + i));
            htds.updateTableDescriptor(htd);
        }
        Thread.sleep(100L);
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((((FSTableDescriptors)htds).get(TableName.valueOf("testHTableDescriptors" + i)) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((((FSTableDescriptors)htds).get(TableName.valueOf("testHTableDescriptors" + i)) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertTrue((String)("expected=20, actual=" + htds.cachehits), (htds.cachehits >= 20L ? 1 : 0) != 0);
    }

    @Test
    public void testHTableDescriptorsNoCache() throws IOException, InterruptedException {
        HTableDescriptor htd;
        int i;
        String name = "testHTableDescriptorsNoCache";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testHTableDescriptorsNoCache");
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir, false, false);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            htd = new HTableDescriptor("testHTableDescriptorsNoCache" + i);
            htds.createTableDescriptor(htd);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf("testHTableDescriptorsNoCache" + i)) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf("testHTableDescriptorsNoCache" + i)) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            htd = new HTableDescriptor(TableName.valueOf("testHTableDescriptorsNoCache" + i));
            htd.addFamily(new HColumnDescriptor("" + i));
            htds.updateTableDescriptor(htd);
        }
        Thread.sleep(100L);
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf("testHTableDescriptorsNoCache" + i)) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf("testHTableDescriptorsNoCache" + i)) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertTrue((String)("expected=0, actual=" + htds.cachehits), (htds.cachehits == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGetAll() throws IOException, InterruptedException {
        String name = "testGetAll";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testGetAll");
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(fs, rootdir);
        int count = 4;
        for (int i = 0; i < 4; ++i) {
            HTableDescriptor htd = new HTableDescriptor("testGetAll" + i);
            htds.createTableDescriptor(htd);
        }
        HTableDescriptor htd = new HTableDescriptor(HTableDescriptor.META_TABLEDESC.getTableName());
        htds.createTableDescriptor(htd);
        Assert.assertTrue((htds.getAll().size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testCacheConsistency() throws IOException, InterruptedException {
        int i;
        String name = "testCacheConsistency";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testCacheConsistency");
        FSTableDescriptorsTest chtds = new FSTableDescriptorsTest(fs, rootdir);
        FSTableDescriptorsTest nonchtds = new FSTableDescriptorsTest(fs, rootdir, false, false);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            HTableDescriptor htd = new HTableDescriptor("testCacheConsistency" + i);
            nonchtds.createTableDescriptor(htd);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((((FSTableDescriptors)chtds).get(TableName.valueOf("testCacheConsistency" + i)) != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((nonchtds.getAll().size() == chtds.getAll().size() ? 1 : 0) != 0);
        HTableDescriptor htd = new HTableDescriptor(HTableDescriptor.META_TABLEDESC.getTableName());
        nonchtds.createTableDescriptor(htd);
        Assert.assertTrue((nonchtds.getAll().size() == chtds.getAll().size() ? 1 : 0) != 0);
        for (Map.Entry<String, HTableDescriptor> entry : nonchtds.getAll().entrySet()) {
            String t = entry.getKey();
            HTableDescriptor nchtd = entry.getValue();
            Assert.assertTrue((String)("expected " + htd.toString() + " got: " + ((FSTableDescriptors)chtds).get(TableName.valueOf(t)).toString()), (boolean)nchtd.equals(((FSTableDescriptors)chtds).get(TableName.valueOf(t))));
        }
    }

    @Test
    public void testNoSuchTable() throws IOException {
        String name = "testNoSuchTable";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testNoSuchTable");
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        Assert.assertNull((String)"There shouldn't be any HTD for this table", (Object)htds.get(TableName.valueOf("NoSuchTable")));
    }

    @Test
    public void testUpdates() throws IOException {
        String name = "testUpdates";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testUpdates");
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testUpdates"));
        htds.add(htd);
        htds.add(htd);
        htds.add(htd);
    }

    @Test
    public void testTableInfoFileStatusComparator() {
        FileStatus bare = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp", ".tableinfo"));
        FileStatus future = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + System.currentTimeMillis()));
        FileStatus farFuture = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + System.currentTimeMillis() + 1000));
        FileStatus[] alist = new FileStatus[]{bare, future, farFuture};
        FileStatus[] blist = new FileStatus[]{bare, farFuture, future};
        FileStatus[] clist = new FileStatus[]{farFuture, bare, future};
        Comparator<FileStatus> c = FSTableDescriptors.TABLEINFO_FILESTATUS_COMPARATOR;
        Arrays.sort(alist, c);
        Arrays.sort(blist, c);
        Arrays.sort(clist, c);
        for (int i = 0; i < alist.length; ++i) {
            Assert.assertTrue((boolean)alist[i].equals((Object)blist[i]));
            Assert.assertTrue((boolean)blist[i].equals((Object)clist[i]));
            Assert.assertTrue((boolean)clist[i].equals((Object)(i == 0 ? farFuture : (i == 1 ? future : bare))));
        }
    }

    @Test
    public void testReadingInvalidDirectoryFromFS() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        try {
            new FSTableDescriptors(UTIL.getConfiguration(), fs, FSUtils.getRootDir(UTIL.getConfiguration())).get(TableName.valueOf(".tmp"));
            Assert.fail((String)"Shouldn't be able to read a table descriptor for the archive directory.");
        }
        catch (Exception e) {
            LOG.debug("Correctly got error when reading a table descriptor from the archive directory: " + e.getMessage());
        }
    }

    @Test
    public void testCreateTableDescriptorUpdatesIfExistsAlready() throws IOException {
        Path testdir = UTIL.getDataTestDir("testCreateTableDescriptorUpdatesIfThereExistsAlready");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testCreateTableDescriptorUpdatesIfThereExistsAlready"));
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, testdir);
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Assert.assertFalse((boolean)fstd.createTableDescriptor(htd));
        htd.setValue(Bytes.toBytes("mykey"), Bytes.toBytes("myValue"));
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Path tableDir = fstd.getTableDir(htd.getTableName());
        Path tmpTableDir = new Path(tableDir, ".tmp");
        FileStatus[] statuses = fs.listStatus(tmpTableDir);
        Assert.assertTrue((statuses.length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)htd, (Object)FSTableDescriptors.getTableDescriptorFromFs(fs, tableDir));
    }

    private static class FSTableDescriptorsTest
    extends FSTableDescriptors {
        public FSTableDescriptorsTest(FileSystem fs, Path rootdir) throws IOException {
            this(fs, rootdir, false, true);
        }

        public FSTableDescriptorsTest(FileSystem fs, Path rootdir, boolean fsreadonly, boolean usecache) throws IOException {
            super(UTIL.getConfiguration(), fs, rootdir, fsreadonly, usecache);
        }

        @Override
        public HTableDescriptor get(TableName tablename) throws TableExistsException, FileNotFoundException, IOException {
            LOG.info((super.isUsecache() ? "Cached" : "Non-Cached") + " HTableDescriptor.get() on " + tablename + ", cachehits=" + this.cachehits);
            return super.get(tablename);
        }
    }
}

