/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class MockServer
implements Server {
    static final Log LOG = LogFactory.getLog(MockServer.class);
    static final ServerName NAME = ServerName.valueOf("MockServer", 123, -1L);
    boolean stopped;
    boolean aborted;
    final ZooKeeperWatcher zk;
    final HBaseTestingUtility htu;

    public MockServer() throws ZooKeeperConnectionException, IOException {
        this(null);
    }

    public MockServer(HBaseTestingUtility htu) throws ZooKeeperConnectionException, IOException {
        this(htu, true);
    }

    public MockServer(HBaseTestingUtility htu, boolean zkw) throws ZooKeeperConnectionException, IOException {
        this.htu = htu;
        this.zk = zkw ? new ZooKeeperWatcher(htu.getConfiguration(), NAME.toString(), this, true) : null;
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.fatal("Abort why=" + why, e);
        this.stop(why);
        this.aborted = true;
    }

    @Override
    public void stop(String why) {
        LOG.debug("Stop why=" + why);
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public Configuration getConfiguration() {
        return this.htu.getConfiguration();
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zk;
    }

    @Override
    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    @Override
    public ClusterConnection getConnection() {
        return null;
    }

    @Override
    public MetaTableLocator getMetaTableLocator() {
        return null;
    }

    @Override
    public ServerName getServerName() {
        return NAME;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public ChoreService getChoreService() {
        return null;
    }
}

