/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public class ClassLoaderTestHelper {
    private static final Log LOG = LogFactory.getLog(ClassLoaderTestHelper.class);
    private static final int BUFFER_SIZE = 4096;

    private static boolean createJarArchive(File archiveFile, File[] tobeJared) {
        try {
            byte[] buffer = new byte[4096];
            FileOutputStream stream = new FileOutputStream(archiveFile);
            JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
            for (int i = 0; i < tobeJared.length; ++i) {
                int nRead;
                if (tobeJared[i] == null || !tobeJared[i].exists() || tobeJared[i].isDirectory()) continue;
                JarEntry jarAdd = new JarEntry(tobeJared[i].getName());
                jarAdd.setTime(tobeJared[i].lastModified());
                out.putNextEntry(jarAdd);
                FileInputStream in = new FileInputStream(tobeJared[i]);
                while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
            LOG.info("Adding classes to jar file completed");
            return true;
        }
        catch (Exception ex) {
            LOG.error("Error: " + ex.getMessage());
            return false;
        }
    }

    public static File buildJar(String testDir, String className, String code) throws Exception {
        return ClassLoaderTestHelper.buildJar(testDir, className, code, testDir);
    }

    public static File buildJar(String testDir, String className, String code, String folder) throws Exception {
        String javaCode = code != null ? code : "public class " + className + " {}";
        Path srcDir = new Path(testDir, "src");
        File srcDirPath = new File(srcDir.toString());
        srcDirPath.mkdirs();
        File sourceCodeFile = new File(srcDir.toString(), className + ".java");
        BufferedWriter bw = new BufferedWriter(new FileWriter(sourceCodeFile));
        bw.write(javaCode);
        bw.close();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ArrayList<String> srcFileNames = new ArrayList<String>();
        srcFileNames.add(sourceCodeFile.toString());
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> cu = fm.getJavaFileObjects(sourceCodeFile);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        String currentDir = new File(".").getAbsolutePath();
        String classpath = currentDir + File.separator + "target" + File.separator + "classes" + System.getProperty("path.separator") + System.getProperty("java.class.path") + System.getProperty("path.separator") + System.getProperty("surefire.test.class.path");
        options.add(classpath);
        LOG.debug("Setting classpath to: " + classpath);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fm, null, options, null, cu);
        Assert.assertTrue((String)("Compile file " + sourceCodeFile + " failed."), (boolean)task.call());
        String jarFileName = className + ".jar";
        File jarFile = new File(folder, jarFileName);
        jarFile.getParentFile().mkdirs();
        if (!ClassLoaderTestHelper.createJarArchive(jarFile, new File[]{new File(srcDir.toString(), className + ".class")})) {
            Assert.assertTrue((String)"Build jar file failed.", (boolean)false);
        }
        return jarFile;
    }

    public static void addJarFilesToJar(File targetJar, String libPrefix, File ... srcJars) throws Exception {
        FileOutputStream stream = new FileOutputStream(targetJar);
        JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
        byte[] buffer = new byte[4096];
        for (File jarFile : srcJars) {
            int nRead;
            JarEntry jarAdd = new JarEntry(libPrefix + jarFile.getName());
            jarAdd.setTime(jarFile.lastModified());
            out.putNextEntry(jarAdd);
            FileInputStream in = new FileInputStream(jarFile);
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            in.close();
        }
        out.close();
        stream.close();
        LOG.info("Adding jar file to outer jar file completed");
    }

    static String localDirPath(Configuration conf) {
        return conf.get("hbase.local.dir") + File.separator + "jars" + File.separator;
    }
}

