/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRestoreSnapshotHelper {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TEST_HFILE = "abc";
    private Configuration conf;
    private Path archiveDir;
    private FileSystem fs;
    private Path rootDir;

    @Before
    public void setup() throws Exception {
        this.rootDir = TEST_UTIL.getDataTestDir("testRestore");
        this.archiveDir = new Path(this.rootDir, "archive");
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
        FSUtils.setRootDir(this.conf, this.rootDir);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(TEST_UTIL.getDataTestDir(), true);
    }

    @Test
    public void testRestore() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), this.fs, this.rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("snapshot");
        builder.addRegionV1();
        builder.addRegionV2();
        builder.addRegionV2();
        builder.addRegionV1();
        Path snapshotDir = builder.commit();
        HTableDescriptor htd = builder.getTableDescriptor();
        HBaseProtos.SnapshotDescription desc = builder.getSnapshotDescription();
        HTableDescriptor htdClone = snapshotMock.createHtd("testtb-clone");
        this.testRestore(snapshotDir, desc, htdClone);
        this.verifyRestore(this.rootDir, htd, htdClone);
        HBaseProtos.SnapshotDescription cloneDesc = HBaseProtos.SnapshotDescription.newBuilder().setName("cloneSnapshot").setTable("testtb-clone").build();
        Path cloneDir = FSUtils.getTableDir(this.rootDir, htdClone.getTableName());
        HTableDescriptor htdClone2 = snapshotMock.createHtd("testtb-clone2");
        this.testRestore(cloneDir, cloneDesc, htdClone2);
        this.verifyRestore(this.rootDir, htd, htdClone2);
    }

    private void verifyRestore(Path rootDir, HTableDescriptor sourceHtd, HTableDescriptor htdClone) throws IOException {
        String[] files = SnapshotTestingUtils.listHFileNames(this.fs, FSUtils.getTableDir(rootDir, htdClone.getTableName()));
        Assert.assertEquals((long)12L, (long)files.length);
        for (int i = 0; i < files.length; i += 2) {
            String linkFile = files[i];
            String refFile = files[i + 1];
            Assert.assertTrue((String)(linkFile + " should be a HFileLink"), (boolean)HFileLink.isHFileLink(linkFile));
            Assert.assertTrue((String)(refFile + " should be a Referene"), (boolean)StoreFileInfo.isReference(refFile));
            Assert.assertEquals((Object)sourceHtd.getTableName(), (Object)HFileLink.getReferencedTableName(linkFile));
            Path refPath = this.getReferredToFile(refFile);
            this.LOG.debug("get reference name for file " + refFile + " = " + refPath);
            Assert.assertTrue((String)(refPath.getName() + " should be a HFileLink"), (boolean)HFileLink.isHFileLink(refPath.getName()));
            Assert.assertEquals((Object)linkFile, (Object)refPath.getName());
        }
    }

    public void testRestore(Path snapshotDir, HBaseProtos.SnapshotDescription sd, HTableDescriptor htdClone) throws IOException {
        this.LOG.debug("pre-restore table=" + htdClone.getTableName() + " snapshot=" + snapshotDir);
        FSUtils.logFileSystemState(this.fs, this.rootDir, this.LOG);
        new FSTableDescriptors(this.conf).createTableDescriptor(htdClone);
        RestoreSnapshotHelper helper = this.getRestoreHelper(this.rootDir, snapshotDir, sd, htdClone);
        helper.restoreHdfsRegions();
        this.LOG.debug("post-restore table=" + htdClone.getTableName() + " snapshot=" + snapshotDir);
        FSUtils.logFileSystemState(this.fs, this.rootDir, this.LOG);
    }

    private RestoreSnapshotHelper getRestoreHelper(Path rootDir, Path snapshotDir, HBaseProtos.SnapshotDescription sd, HTableDescriptor htdClone) throws IOException {
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        MonitoredTask status2 = (MonitoredTask)Mockito.mock(MonitoredTask.class);
        SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, snapshotDir, sd);
        return new RestoreSnapshotHelper(this.conf, this.fs, manifest, htdClone, rootDir, monitor, status2);
    }

    private Path getReferredToFile(String referenceName) {
        Path fakeBasePath = new Path(new Path("table", "region"), "cf");
        return StoreFileInfo.getReferredToFile(new Path(fakeBasePath, referenceName));
    }
}

