/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class ExpAsStringVisibilityLabelServiceImpl
implements VisibilityLabelService {
    private static final Log LOG = LogFactory.getLog(ExpAsStringVisibilityLabelServiceImpl.class);
    private static final byte[] DUMMY_VALUE = new byte[0];
    private static final byte STRING_SERIALIZATION_FORMAT = 2;
    private static final Tag STRING_SERIALIZATION_FORMAT_TAG = new Tag(4, new byte[]{2});
    private final ExpressionParser expressionParser = new ExpressionParser();
    private final ExpressionExpander expressionExpander = new ExpressionExpander();
    private Configuration conf;
    private Region labelsRegion;
    private List<ScanLabelGenerator> scanLabelGenerators;

    @Override
    public OperationStatus[] addLabels(List<byte[]> labels) throws IOException {
        OperationStatus[] status2 = new OperationStatus[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            status2[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return status2;
    }

    @Override
    public OperationStatus[] setAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        Put p = new Put(user);
        for (byte[] auth : authLabels) {
            p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, auth, DUMMY_VALUE);
        }
        this.labelsRegion.put(p);
        for (int i = 0; i < authLabels.size(); ++i) {
            finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return finalOpStatus;
    }

    @Override
    public OperationStatus[] clearAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        List<String> currentAuths;
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        if (AuthUtil.isGroupPrincipal(Bytes.toString(user))) {
            String group = AuthUtil.getGroupName(Bytes.toString(user));
            currentAuths = this.getGroupAuths(new String[]{group}, true);
        } else {
            currentAuths = this.getUserAuths(user, true);
        }
        Delete d = new Delete(user);
        int i = 0;
        for (byte[] authLabel : authLabels) {
            String authLabelStr = Bytes.toString(authLabel);
            if (currentAuths.contains(authLabelStr)) {
                d.deleteColumns(VisibilityConstants.LABELS_TABLE_FAMILY, authLabel);
            } else {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, new InvalidLabelException("Label '" + authLabelStr + "' is not set for the user " + Bytes.toString(user)));
            }
            ++i;
        }
        this.labelsRegion.delete(d);
        for (i = 0; i < authLabels.size(); ++i) {
            if (finalOpStatus[i] != null) continue;
            finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return finalOpStatus;
    }

    @Override
    @Deprecated
    public List<String> getAuths(byte[] user, boolean systemCall) throws IOException {
        return this.getUserAuths(user, systemCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUserAuths(byte[] user, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        ArrayList<String> auths = new ArrayList<String>();
        Get get = new Get(user);
        List<Cell> cells = null;
        if (this.labelsRegion == null) {
            try (Table table = null;){
                table = new HTable(this.conf, VisibilityConstants.LABELS_TABLE_NAME);
                Result result = table.get(get);
                cells = result.listCells();
            }
        } else {
            cells = this.labelsRegion.get(get, false);
        }
        if (cells != null) {
            for (Cell cell : cells) {
                String auth = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                auths.add(auth);
            }
        }
        return auths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGroupAuths(String[] groups, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        ArrayList<String> auths = new ArrayList<String>();
        if (groups != null && groups.length > 0) {
            for (String group : groups) {
                Get get = new Get(Bytes.toBytes(AuthUtil.toGroupEntry(group)));
                List<Cell> cells = null;
                if (this.labelsRegion == null) {
                    try (Table table = null;){
                        table = new HTable(this.conf, VisibilityConstants.LABELS_TABLE_NAME);
                        Result result = table.get(get);
                        cells = result.listCells();
                    }
                } else {
                    cells = this.labelsRegion.get(get, false);
                }
                if (cells == null) continue;
                for (Cell cell : cells) {
                    String auth = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    auths.add(auth);
                }
            }
        }
        return auths;
    }

    @Override
    public List<String> listLabels(String regex) throws IOException {
        return new ArrayList<String>();
    }

    @Override
    public List<Tag> createVisibilityExpTags(String visExpression, boolean withSerializationFormat, boolean checkAuths) throws IOException {
        ExpressionNode node = null;
        try {
            node = this.expressionParser.parse(visExpression);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        node = this.expressionExpander.expand(node);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (withSerializationFormat) {
            tags.add(STRING_SERIALIZATION_FORMAT_TAG);
        }
        if (node instanceof NonLeafExpressionNode && ((NonLeafExpressionNode)node).getOperator() == Operator.OR) {
            for (ExpressionNode child : ((NonLeafExpressionNode)node).getChildExps()) {
                tags.add(this.createTag(child));
            }
        } else {
            tags.add(this.createTag(node));
        }
        return tags;
    }

    @Override
    public VisibilityExpEvaluator getVisibilityExpEvaluator(Authorizations authorizations) throws IOException {
        if (this.isReadFromSystemAuthUser()) {
            return new VisibilityExpEvaluator(){

                @Override
                public boolean evaluate(Cell cell) throws IOException {
                    return true;
                }
            };
        }
        ArrayList<String> authLabels = null;
        for (ScanLabelGenerator scanLabelGenerator : this.scanLabelGenerators) {
            try {
                authLabels = scanLabelGenerator.getLabels(VisibilityUtils.getActiveUser(), authorizations);
                authLabels = authLabels == null ? new ArrayList<String>() : authLabels;
                authorizations = new Authorizations(authLabels);
            }
            catch (Throwable t) {
                LOG.error(t);
                throw new IOException(t);
            }
        }
        final ArrayList<String> authLabelsFinal = authLabels;
        return new VisibilityExpEvaluator(){

            @Override
            public boolean evaluate(Cell cell) throws IOException {
                boolean visibilityTagPresent = false;
                if (cell.getTagsLength() > 0) {
                    Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
                    while (tagsItr.hasNext()) {
                        short len;
                        int offset;
                        boolean includeKV = true;
                        Tag tag = tagsItr.next();
                        if (tag.getType() != 2) continue;
                        visibilityTagPresent = true;
                        int endOffset = offset + tag.getTagLength();
                        for (offset = tag.getTagOffset(); offset < endOffset; offset += len) {
                            String label;
                            len = Bytes.toShort(tag.getBuffer(), offset);
                            offset += 2;
                            if (len < 0) {
                                len = (short)(-1 * len);
                                label = Bytes.toString(tag.getBuffer(), offset, len);
                                if (!authLabelsFinal.contains(label)) continue;
                                includeKV = false;
                                break;
                            }
                            label = Bytes.toString(tag.getBuffer(), offset, len);
                            if (authLabelsFinal.contains(label)) continue;
                            includeKV = false;
                            break;
                        }
                        if (!includeKV) continue;
                        return true;
                    }
                }
                return !visibilityTagPresent;
            }
        };
    }

    protected boolean isReadFromSystemAuthUser() throws IOException {
        User user = VisibilityUtils.getActiveUser();
        return this.havingSystemAuth(user);
    }

    private Tag createTag(ExpressionNode node) throws IOException {
        byte[] bLabel;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> notLabels = new ArrayList<String>();
        this.extractLabels(node, labels, notLabels);
        Collections.sort(labels);
        Collections.sort(notLabels);
        for (String label : notLabels) {
            bLabel = Bytes.toBytes(label);
            short length = (short)bLabel.length;
            length = (short)(-1 * length);
            dos.writeShort(length);
            dos.write(bLabel);
        }
        for (String label : labels) {
            bLabel = Bytes.toBytes(label);
            dos.writeShort(bLabel.length);
            dos.write(bLabel);
        }
        return new Tag(2, baos.toByteArray());
    }

    private void extractLabels(ExpressionNode node, List<String> labels, List<String> notLabels) {
        if (node.isSingleNode()) {
            if (node instanceof NonLeafExpressionNode) {
                LeafExpressionNode lNode = (LeafExpressionNode)((NonLeafExpressionNode)node).getChildExps().get(0);
                notLabels.add(lNode.getIdentifier());
            } else {
                labels.add(((LeafExpressionNode)node).getIdentifier());
            }
        } else {
            NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
            assert (nlNode.getOperator() == Operator.AND);
            List<ExpressionNode> childExps = nlNode.getChildExps();
            for (ExpressionNode child : childExps) {
                this.extractLabels(child, labels, notLabels);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void init(RegionCoprocessorEnvironment e) throws IOException {
        this.scanLabelGenerators = VisibilityUtils.getScanLabelGenerators(this.conf);
        if (e.getRegion().getRegionInfo().getTable().equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = e.getRegion();
        }
    }

    @Override
    @Deprecated
    public boolean havingSystemAuth(byte[] user) throws IOException {
        if (Superusers.isSuperUser(Bytes.toString(user))) {
            return true;
        }
        List<String> auths = this.getUserAuths(user, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("The auths for user " + Bytes.toString(user) + " are " + auths);
        }
        return auths.contains("system");
    }

    @Override
    public boolean havingSystemAuth(User user) throws IOException {
        if (Superusers.isSuperUser(user)) {
            return true;
        }
        HashSet<String> auths = new HashSet<String>();
        auths.addAll(this.getUserAuths(Bytes.toBytes(user.getShortName()), true));
        auths.addAll(this.getGroupAuths(user.getGroupNames(), true));
        return auths.contains("system");
    }

    @Override
    public boolean matchVisibility(List<Tag> putTags, Byte putTagsFormat, List<Tag> deleteTags, Byte deleteTagsFormat) throws IOException {
        assert (putTagsFormat == 2);
        assert (deleteTagsFormat == 2);
        return ExpAsStringVisibilityLabelServiceImpl.checkForMatchingVisibilityTagsWithSortedOrder(putTags, deleteTags);
    }

    private static boolean checkForMatchingVisibilityTagsWithSortedOrder(List<Tag> putVisTags, List<Tag> deleteVisTags) {
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (Tag tag : deleteVisTags) {
                matchFound = false;
                for (Tag givenTag : putVisTags) {
                    if (!Bytes.equals(tag.getBuffer(), tag.getTagOffset(), tag.getTagLength(), givenTag.getBuffer(), givenTag.getTagOffset(), givenTag.getTagLength())) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }

    @Override
    public byte[] encodeVisibilityForReplication(List<Tag> tags, Byte serializationFormat) throws IOException {
        if (tags.size() > 0 && (serializationFormat == null || serializationFormat == 2)) {
            return this.createModifiedVisExpression(tags);
        }
        return null;
    }

    private byte[] createModifiedVisExpression(List<Tag> tags) throws IOException {
        StringBuilder visibilityString = new StringBuilder();
        for (Tag tag : tags) {
            short len;
            int offset;
            if (tag.getType() != 2) continue;
            if (visibilityString.length() != 0) {
                visibilityString.append(")|");
            }
            int endOffset = offset + tag.getTagLength();
            boolean expressionStart = true;
            for (offset = tag.getTagOffset(); offset < endOffset; offset += len) {
                String label;
                len = Bytes.toShort(tag.getBuffer(), offset);
                offset += 2;
                if (len < 0) {
                    len = (short)(-1 * len);
                    label = Bytes.toString(tag.getBuffer(), offset, len);
                    if (expressionStart) {
                        visibilityString.append("(!" + CellVisibility.quote(label));
                    } else {
                        visibilityString.append("&!" + CellVisibility.quote(label));
                    }
                } else {
                    label = Bytes.toString(tag.getBuffer(), offset, len);
                    if (expressionStart) {
                        visibilityString.append("(" + CellVisibility.quote(label));
                    } else {
                        visibilityString.append("&" + CellVisibility.quote(label));
                    }
                }
                expressionStart = false;
            }
        }
        if (visibilityString.length() != 0) {
            visibilityString.append(")");
            return Bytes.toBytes(visibilityString.toString());
        }
        return null;
    }
}

