/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.log4j.Level;
import org.apache.hive.org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCellACLs
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestCellACLs.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] TEST_Q3;
    private static final byte[] TEST_Q4;
    private static final byte[] ZERO;
    private static final byte[] ONE;
    private static Configuration conf;
    private static User USER_OWNER;
    private static User USER_OTHER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestCellACLs.enableSecurity(conf);
        TestCellACLs.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment((Class)AccessController.class, (Coprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        rsHost.createEnvironment((Class)AccessController.class, (Coprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME);
        USER_OWNER = User.createUserForTesting(conf, "owner", new String[0]);
        USER_OTHER = User.createUserForTesting(conf, "other", new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        admin.createTable(htd, new byte[][]{Bytes.toBytes("s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName());
        LOG.info("Sleeping a second because of HBASE-12581");
        Threads.sleep(1000L);
    }

    @Test
    public void testCellPermissions() throws Exception {
        TestCellACLs.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(Permission.Action.READ));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q2, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(Permission.Action.READ, Permission.Action.WRITE));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q3, ZERO).add(TEST_FAMILY, TEST_Q4, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ3 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q3);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ4 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q4);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        TestCellACLs.verifyAllowed(getQ1, USER_OTHER);
        TestCellACLs.verifyAllowed(getQ2, USER_OTHER);
        TestCellACLs.verifyIfNull(getQ3, USER_OTHER);
        TestCellACLs.verifyIfNull(getQ4, USER_OTHER);
        final ArrayList scanResults = Lists.newArrayList();
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Cell> run() throws Exception {
                Scan scan = new Scan();
                scan.setStartRow(TEST_ROW);
                scan.setStopRow(Bytes.add(TEST_ROW, new byte[]{0}));
                scan.addFamily(TEST_FAMILY);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    ResultScanner scanner = t.getScanner(scan);
                    Result result = null;
                    do {
                        if ((result = scanner.next()) == null) continue;
                        scanResults.addAll(result.listCells());
                    } while (result != null);
                }
                return scanResults;
            }
        };
        scanResults.clear();
        TestCellACLs.verifyAllowed(scanAction, USER_OWNER);
        Assert.assertEquals((long)4L, (long)scanResults.size());
        scanResults.clear();
        TestCellACLs.verifyAllowed(scanAction, USER_OTHER);
        Assert.assertEquals((long)2L, (long)scanResults.size());
        SecureTestUtil.AccessTestAction incrementQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1, 1L);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction incrementQ2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2, 1L);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction incrementQ2newDenyACL = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2, 1L);
                i.setACL(USER_OTHER.getShortName(), new Permission(Permission.Action.READ));
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction incrementQ3 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q3, 1L);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        TestCellACLs.verifyDenied(incrementQ1, USER_OTHER);
        TestCellACLs.verifyDenied(incrementQ3, USER_OTHER);
        TestCellACLs.verifyAllowed(incrementQ2, USER_OTHER);
        TestCellACLs.verifyAllowed(incrementQ2newDenyACL, USER_OTHER);
        TestCellACLs.verifyDenied(incrementQ2, USER_OTHER);
        SecureTestUtil.AccessTestAction deleteFamily = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).deleteFamily(TEST_FAMILY);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.delete(delete);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).deleteColumn(TEST_FAMILY, TEST_Q1);
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.delete(delete);
                }
                return null;
            }
        };
        TestCellACLs.verifyDenied(deleteFamily, USER_OTHER);
        TestCellACLs.verifyDenied(deleteQ1, USER_OTHER);
        TestCellACLs.verifyAllowed(deleteQ1, USER_OWNER);
    }

    @Test
    public void testCoveringCheck() throws Exception {
        TestCellACLs.grantOnTable(TEST_UTIL, USER_OTHER.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestCellACLs.verifyDenied(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OTHER);
        TestCellACLs.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLs.verifyDenied(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ONE);
                    t.put(p);
                }
                return null;
            }
        }, USER_OTHER);
        TestCellACLs.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLs.this.TEST_TABLE.getTableName());){
                    Result result = t.get(new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1));
                    return result;
                }
            }
        }, USER_OTHER);
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + this.TEST_TABLE.getTableName());
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions(conf, this.TEST_TABLE.getTableName()).size());
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY = Bytes.toBytes("f1");
        TEST_ROW = Bytes.toBytes("cellpermtest");
        TEST_Q1 = Bytes.toBytes("q1");
        TEST_Q2 = Bytes.toBytes("q2");
        TEST_Q3 = Bytes.toBytes("q3");
        TEST_Q4 = Bytes.toBytes("q4");
        ZERO = Bytes.toBytes(0L);
        ONE = Bytes.toBytes(1L);
    }
}

