/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.collect.Maps;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public class SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(SecureTestUtil.class);
    private static final int WAIT_TIME = 10000;

    public static void configureSuperuser(Configuration conf) throws IOException {
        String currentUser = User.getCurrent().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("admin,");
        sb.append(currentUser);
        for (int i = 0; i < 5; ++i) {
            sb.append(',');
            sb.append(currentUser);
            sb.append(".hfs.");
            sb.append(i);
        }
        conf.set("hbase.superuser", sb.toString());
    }

    public static void enableSecurity(Configuration conf) throws IOException {
        conf.set("hadoop.security.authorization", "false");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName() + "," + MasterSyncObserver.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName() + "," + SecureBulkLoadEndpoint.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", AccessController.class.getName());
        conf.setInt("hfile.format.version", 3);
        SecureTestUtil.configureSuperuser(conf);
    }

    public static void verifyConfiguration(Configuration conf) {
        if (!(conf.get("hbase.coprocessor.master.classes").contains(AccessController.class.getName()) && conf.get("hbase.coprocessor.region.classes").contains(AccessController.class.getName()) && conf.get("hbase.coprocessor.regionserver.classes").contains(AccessController.class.getName()))) {
            throw new RuntimeException("AccessController is missing from a system coprocessor list");
        }
        if (conf.getInt("hfile.format.version", 2) < 3) {
            throw new RuntimeException("Post 0.96 security features require HFile version >= 3");
        }
    }

    public static void checkTablePerms(Configuration conf, TableName table, byte[] family, byte[] column, Permission.Action ... actions2) throws IOException {
        Permission[] perms = new Permission[actions2.length];
        for (int i = 0; i < actions2.length; ++i) {
            perms[i] = new TablePermission(table, family, column, actions2[i]);
        }
        SecureTestUtil.checkTablePerms(conf, table, perms);
    }

    public static void checkTablePerms(Configuration conf, TableName table, Permission ... perms) throws IOException {
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission p : perms) {
            request.addPermission(ProtobufUtil.toPermission(p));
        }
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table acl = connection.getTable(table);){
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(acl.coprocessorService(new byte[0]));
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException(se);
            }
        }
    }

    public static void verifyAllowed(User user, AccessTestAction ... actions2) throws Exception {
        for (AccessTestAction action : actions2) {
            try {
                List results;
                Object obj = user.runAs(action);
                if (obj == null || !(obj instanceof List) || (results = (List)obj) == null || !results.isEmpty()) continue;
                Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyAllowed(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyAllowed(user, action);
        }
    }

    public static void verifyAllowed(User user, AccessTestAction action, int count) throws Exception {
        try {
            Object obj = user.runAs(action);
            if (obj != null && obj instanceof List) {
                List results = (List)obj;
                if (results != null && results.isEmpty()) {
                    Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
                }
                Assert.assertEquals((long)count, (long)results.size());
            }
        }
        catch (AccessDeniedException ade) {
            Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
        }
    }

    public static void verifyDenied(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyDenied(user, action);
        }
    }

    public static void verifyIfEmptyList(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            try {
                Object obj = user.runAs(action);
                if (obj != null && obj instanceof List) {
                    List results = (List)obj;
                    if (results == null || results.isEmpty()) continue;
                    Assert.fail((String)("Unexpected action results: " + results + " for user '" + user.getShortName() + "'"));
                    continue;
                }
                Assert.fail((String)("Unexpected results for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyIfNull(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            try {
                Object obj = user.runAs(action);
                if (obj == null) continue;
                Assert.fail((String)("Non null results from action for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyDenied(User user, AccessTestAction ... actions2) throws Exception {
        for (AccessTestAction action : actions2) {
            try {
                user.runAs(action);
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
            catch (IOException e) {
                boolean isAccessDeniedException = false;
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    for (Throwable ex : ((RetriesExhaustedWithDetailsException)e).getCauses()) {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    }
                } else {
                    Throwable ex = e;
                    do {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    } while ((ex = ex.getCause()) != null);
                }
                if (isAccessDeniedException) continue;
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
            catch (UndeclaredThrowableException ute) {
                ServiceException se;
                Throwable ex = ute.getUndeclaredThrowable();
                if (ex instanceof PrivilegedActionException) {
                    ex = ((PrivilegedActionException)ex).getException();
                }
                if (ex instanceof ServiceException && (se = (ServiceException)ex).getCause() != null && se.getCause() instanceof AccessDeniedException) {
                    return;
                }
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
        }
    }

    private static List<AccessController> getAccessControllers(MiniHBaseCluster cluster) {
        ArrayList<AccessController> result = Lists.newArrayList();
        for (JVMClusterUtil.RegionServerThread t : cluster.getLiveRegionServerThreads()) {
            for (Region region : t.getRegionServer().getOnlineRegionsLocalContext()) {
                Coprocessor cp = region.getCoprocessorHost().findCoprocessor(AccessController.class.getName());
                if (cp == null) continue;
                result.add((AccessController)cp);
            }
        }
        return result;
    }

    private static Map<AccessController, Long> getAuthManagerMTimes(MiniHBaseCluster cluster) {
        HashMap<AccessController, Long> result = Maps.newHashMap();
        for (AccessController ac : SecureTestUtil.getAccessControllers(cluster)) {
            result.put(ac, ac.getAuthManager().getMTime());
        }
        return result;
    }

    private static void updateACLs(final HBaseTestingUtility util, Callable c) throws Exception {
        final Map<AccessController, Long> oldMTimes = SecureTestUtil.getAuthManagerMTimes(util.getHBaseCluster());
        c.call();
        util.waitFor(10000L, 100L, new Waiter.Predicate<IOException>(){

            @Override
            public boolean evaluate() throws IOException {
                Map mtimes = SecureTestUtil.getAuthManagerMTimes(util.getHBaseCluster());
                for (Map.Entry e : mtimes.entrySet()) {
                    if (!oldMTimes.containsKey(e.getKey())) {
                        LOG.error("Snapshot of AccessController state does not include instance on region " + ((AccessController)e.getKey()).getRegion().getRegionInfo().getRegionNameAsString());
                        return false;
                    }
                    long old = (Long)oldMTimes.get(e.getKey());
                    long now = (Long)e.getValue();
                    if (now > old) continue;
                    LOG.info("AccessController on region " + ((AccessController)e.getKey()).getRegion().getRegionInfo().getRegionNameAsString() + " has not updated: mtime=" + now);
                    return false;
                }
                return true;
            }
        });
    }

    public static void grantGlobal(final HBaseTestingUtility util, final String user, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(util.getConfiguration());
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.grant(protocol, user, actions2);
                }
                return null;
            }
        });
    }

    public static void revokeGlobal(final HBaseTestingUtility util, final String user, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(util.getConfiguration());
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.revoke(protocol, user, actions2);
                }
                return null;
            }
        });
    }

    public static void grantOnNamespace(final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(util.getConfiguration());
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.grant(protocol, user, namespace, actions2);
                }
                return null;
            }
        });
    }

    public static void grantOnNamespaceUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final String namespace, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant(connection, namespace, user, actions2);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespaceUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final String namespace, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke(connection, namespace, user, actions2);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespace(final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(util.getConfiguration());
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.revoke(protocol, user, namespace, actions2);
                }
                return null;
            }
        });
    }

    public static void grantOnTable(final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(util.getConfiguration());
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.grant(protocol, user, table, family, qualifier, actions2);
                }
                return null;
            }
        });
    }

    public static void grantOnTableUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant(connection, table, user, family, qualifier, actions2);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void grantGlobalUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant(connection, user, actions2);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeFromTable(final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(util.getConfiguration());
                     Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.revoke(protocol, user, table, family, qualifier, actions2);
                }
                return null;
            }
        });
    }

    public static void revokeFromTableUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke(connection, table, user, family, qualifier, actions2);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeGlobalUsingAccessControlClient(HBaseTestingUtility util, final Connection connection, final String user, final Permission.Action ... actions2) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke(connection, user, actions2);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static Table createTable(HBaseTestingUtility testUtil, TableName tableName, byte[][] families) throws Exception {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
        }
        SecureTestUtil.createTable(testUtil, testUtil.getHBaseAdmin(), htd);
        return testUtil.getConnection().getTable(htd.getTableName());
    }

    public static void createTable(HBaseTestingUtility testUtil, HTableDescriptor htd) throws Exception {
        SecureTestUtil.createTable(testUtil, testUtil.getHBaseAdmin(), htd);
    }

    public static void createTable(HBaseTestingUtility testUtil, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        SecureTestUtil.createTable(testUtil, testUtil.getHBaseAdmin(), htd, splitKeys);
    }

    public static void createTable(HBaseTestingUtility testUtil, Admin admin, HTableDescriptor htd) throws Exception {
        SecureTestUtil.createTable(testUtil, admin, htd, null);
    }

    public static void createTable(HBaseTestingUtility testUtil, Admin admin, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        observer.tableCreationLatch = new CountDownLatch(1);
        if (splitKeys != null) {
            admin.createTable(htd, splitKeys);
        } else {
            admin.createTable(htd);
        }
        observer.tableCreationLatch.await();
        observer.tableCreationLatch = null;
        testUtil.waitUntilAllRegionsAssigned(htd.getTableName());
    }

    public static void deleteTable(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        SecureTestUtil.deleteTable(testUtil, testUtil.getHBaseAdmin(), tableName);
    }

    public static void createNamespace(HBaseTestingUtility testUtil, NamespaceDescriptor nsDesc) throws Exception {
        testUtil.getHBaseAdmin().createNamespace(nsDesc);
    }

    public static void deleteNamespace(HBaseTestingUtility testUtil, String namespace) throws Exception {
        testUtil.getHBaseAdmin().deleteNamespace(namespace);
    }

    public static void deleteTable(HBaseTestingUtility testUtil, Admin admin, TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        observer.tableDeletionLatch = new CountDownLatch(1);
        try {
            admin.disableTable(tableName);
        }
        catch (TableNotEnabledException e) {
            LOG.debug("Table: " + tableName + " already disabled, so just deleting it.");
        }
        admin.deleteTable(tableName);
        observer.tableDeletionLatch.await();
        observer.tableDeletionLatch = null;
    }

    public static String convertToNamespace(String namespace) {
        return '@' + namespace;
    }

    public static void checkGlobalPerms(HBaseTestingUtility testUtil, Permission.Action ... actions2) throws IOException {
        Permission[] perms = new Permission[actions2.length];
        for (int i = 0; i < actions2.length; ++i) {
            perms[i] = new Permission(actions2[i]);
        }
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission.Action a : actions2) {
            request.addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(AccessControlProtos.GlobalPermission.newBuilder().addAction(ProtobufUtil.toPermissionAction(a)).build()));
        }
        try (Connection conn = ConnectionFactory.createConnection(testUtil.getConfiguration());
             Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
            CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(channel);
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException(se);
            }
        }
    }

    public static void checkTablePerms(HBaseTestingUtility testUtil, TableName table, byte[] family, byte[] column, Permission.Action ... actions2) throws IOException {
        Permission[] perms = new Permission[actions2.length];
        for (int i = 0; i < actions2.length; ++i) {
            perms[i] = new TablePermission(table, family, column, actions2[i]);
        }
        SecureTestUtil.checkTablePerms(testUtil, table, perms);
    }

    public static void checkTablePerms(HBaseTestingUtility testUtil, TableName table, Permission ... perms) throws IOException {
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission p : perms) {
            request.addPermission(ProtobufUtil.toPermission(p));
        }
        try (Connection conn = ConnectionFactory.createConnection(testUtil.getConfiguration());
             Table acl = conn.getTable(table);){
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(acl.coprocessorService(new byte[0]));
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException(se);
            }
        }
    }

    public static class MasterSyncObserver
    extends BaseMasterObserver {
        volatile CountDownLatch tableCreationLatch = null;
        volatile CountDownLatch tableDeletionLatch = null;

        @Override
        public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (this.tableCreationLatch != null) {
                this.tableCreationLatch.countDown();
            }
        }

        @Override
        public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            if (this.tableDeletionLatch != null) {
                this.tableDeletionLatch.countDown();
            }
        }
    }

    static interface AccessTestAction
    extends PrivilegedExceptionAction<Object> {
    }
}

