/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationTrackerZKImpl {
    private static final Log LOG = LogFactory.getLog(TestReplicationTrackerZKImpl.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private ZooKeeperWatcher zkw;
    private ReplicationPeers rp;
    private ReplicationTracker rt;
    private AtomicInteger rsRemovedCount;
    private String rsRemovedData;
    private AtomicInteger plChangedCount;
    private List<String> plChangedData;
    private AtomicInteger peerRemovedCount;
    private String peerRemovedData;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        ZooKeeperWatcher zk = HBaseTestingUtility.getZooKeeperWatcher(utility);
        ZKUtil.createWithParents(zk, zk.rsZNode);
    }

    @Before
    public void setUp() throws Exception {
        this.zkw = HBaseTestingUtility.getZooKeeperWatcher(utility);
        String fakeRs1 = ZKUtil.joinZNode(this.zkw.rsZNode, "hostname1.example.org:1234");
        try {
            ZKClusterId.setClusterId(this.zkw, new ClusterId());
            this.rp = ReplicationFactory.getReplicationPeers(this.zkw, conf, this.zkw);
            this.rp.init();
            this.rt = ReplicationFactory.getReplicationTracker(this.zkw, this.rp, conf, this.zkw, new DummyServer(fakeRs1));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during test setup: " + e));
        }
        this.rsRemovedCount = new AtomicInteger(0);
        this.rsRemovedData = "";
        this.plChangedCount = new AtomicInteger(0);
        this.plChangedData = new ArrayList<String>();
        this.peerRemovedCount = new AtomicInteger(0);
        this.peerRemovedData = "";
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }

    @Test
    public void testGetListOfRegionServers() throws Exception {
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents(this.zkw, ZKUtil.joinZNode(this.zkw.rsZNode, "hostname1.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents(this.zkw, ZKUtil.joinZNode(this.zkw.rsZNode, "hostname2.example.org:1234"));
        Assert.assertEquals((long)2L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode(this.zkw, ZKUtil.joinZNode(this.zkw.rsZNode, "hostname2.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode(this.zkw, ZKUtil.joinZNode(this.zkw.rsZNode, "hostname1.example.org:1234"));
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
    }

    @Test(timeout=30000L)
    public void testRegionServerRemovedEvent() throws Exception {
        ZKUtil.createAndWatch(this.zkw, ZKUtil.joinZNode(this.zkw.rsZNode, "hostname2.example.org:1234"), HConstants.EMPTY_BYTE_ARRAY);
        this.rt.registerListener(new DummyReplicationListener());
        ZKUtil.deleteNode(this.zkw, ZKUtil.joinZNode(this.zkw.rsZNode, "hostname2.example.org:1234"));
        while (this.rsRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"hostname2.example.org:1234", (Object)this.rsRemovedData);
    }

    @Test(timeout=30000L)
    public void testPeerRemovedEvent() throws Exception {
        this.rp.addPeer("5", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()), null);
        this.rt.registerListener(new DummyReplicationListener());
        this.rp.removePeer("5");
        while (this.peerRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"5", (Object)this.peerRemovedData);
    }

    @Test(timeout=30000L)
    public void testPeerListChangedEvent() throws Exception {
        this.rp.addPeer("5", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()), null);
        this.zkw.getRecoverableZooKeeper().getZooKeeper().getChildren("/hbase/replication/peers/5", true);
        this.rt.registerListener(new DummyReplicationListener());
        this.rp.disablePeer("5");
        int tmp = this.plChangedCount.get();
        LOG.info("Peer count=" + tmp);
        ZKUtil.deleteNode(this.zkw, "/hbase/replication/peers/5/peer-state");
        while (this.plChangedCount.get() <= tmp) {
            Thread.sleep(100L);
            LOG.info("Peer count=" + tmp);
        }
        Assert.assertEquals((long)1L, (long)this.plChangedData.size());
        Assert.assertTrue((boolean)this.plChangedData.contains("5"));
        this.rp.removePeer("5");
    }

    @Test(timeout=30000L)
    public void testPeerNameControl() throws Exception {
        int exists = 0;
        int hyphen = 0;
        this.rp.addPeer("6", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()), null);
        try {
            this.rp.addPeer("6", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()), null);
        }
        catch (IllegalArgumentException e) {
            ++exists;
        }
        try {
            this.rp.addPeer("6-ec2", new ReplicationPeerConfig().setClusterKey(utility.getClusterKey()), null);
        }
        catch (IllegalArgumentException e) {
            ++hyphen;
        }
        Assert.assertEquals((long)1L, (long)exists);
        Assert.assertEquals((long)1L, (long)hyphen);
        this.rp.removePeer("6");
    }

    private class DummyServer
    implements Server {
        private String serverName;
        private boolean isAborted = false;
        private boolean isStopped = false;

        public DummyServer(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public Configuration getConfiguration() {
            return conf;
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            return TestReplicationTrackerZKImpl.this.zkw;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf(this.serverName);
        }

        @Override
        public void abort(String why, Throwable e) {
            LOG.info("Aborting " + this.serverName);
            this.isAborted = true;
        }

        @Override
        public boolean isAborted() {
            return this.isAborted;
        }

        @Override
        public void stop(String why) {
            this.isStopped = true;
        }

        @Override
        public boolean isStopped() {
            return this.isStopped;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }

    private class DummyReplicationListener
    implements ReplicationListener {
        private DummyReplicationListener() {
        }

        @Override
        public void regionServerRemoved(String regionServer) {
            TestReplicationTrackerZKImpl.this.rsRemovedData = regionServer;
            TestReplicationTrackerZKImpl.this.rsRemovedCount.getAndIncrement();
            LOG.debug("Received regionServerRemoved event: " + regionServer);
        }

        @Override
        public void peerRemoved(String peerId) {
            TestReplicationTrackerZKImpl.this.peerRemovedData = peerId;
            TestReplicationTrackerZKImpl.this.peerRemovedCount.getAndIncrement();
            LOG.debug("Received peerRemoved event: " + peerId);
        }

        @Override
        public void peerListChanged(List<String> peerIds) {
            TestReplicationTrackerZKImpl.this.plChangedData.clear();
            TestReplicationTrackerZKImpl.this.plChangedData.addAll(peerIds);
            int count = TestReplicationTrackerZKImpl.this.plChangedCount.getAndIncrement();
            LOG.debug("Received peerListChanged event " + count);
        }
    }
}

