/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationSmallTests
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationSmallTests.class);

    @Before
    public void setUp() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getHBaseAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        utility1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(1000);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info("Still got " + res.length + " rows");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testDeleteTypes() throws Exception {
        Result res;
        int i;
        LOG.info("testDeleteTypes");
        byte[] v1 = Bytes.toBytes("v1");
        byte[] v2 = Bytes.toBytes("v2");
        byte[] v3 = Bytes.toBytes("v3");
        htable1 = new HTable(conf1, tableName);
        long t = EnvironmentEdgeManager.currentTime();
        Put put = new Put(row);
        put.add(famName, row, t, v1);
        htable1.put(put);
        put = new Put(row);
        put.add(famName, row, t + 1L, v2);
        htable1.put(put);
        put = new Put(row);
        put.add(famName, row, t + 2L, v3);
        htable1.put(put);
        Get get = new Get(row);
        get.setMaxVersions();
        for (int i2 = 0; i2 < 10; ++i2) {
            Result res2;
            if (i2 == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res2 = htable2.get(get)).size() >= 3) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue(res2.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue(res2.rawCells()[1]), (byte[])v2);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue(res2.rawCells()[2]), (byte[])v1);
                break;
            }
            LOG.info("Rows not available");
            Thread.sleep(500L);
        }
        Delete d = new Delete(row);
        d.deleteColumn(famName, row, t);
        htable1.delete(d);
        get = new Get(row);
        get.setMaxVersions();
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() <= 2) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue(res.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue(res.rawCells()[1]), (byte[])v2);
                break;
            }
            LOG.info("Version not deleted");
            Thread.sleep(500L);
        }
        d = new Delete(row);
        d.deleteColumns(famName, row, t + 2L);
        htable1.delete(d);
        get = new Get(row);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info("Rows not deleted");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testSimplePutDelete() throws Exception {
        LOG.info("testSimplePutDelete");
        Put put = new Put(row);
        put.add(famName, row, row);
        htable1 = new HTable(conf1, tableName);
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
        Delete del = new Delete(row);
        htable1.delete(del);
        get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info("Row not deleted");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testSmallBatch() throws Exception {
        LOG.info("testSmallBatch");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes(i));
            put.add(famName, row, row);
            puts.add(put);
        }
        htable1.put(puts);
        Scan scan = new Scan();
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)100L, (long)res1.length);
        for (int i = 0; i < 10; ++i) {
            scan = new Scan();
            if (i == 9) {
                Assert.fail((String)"Waited too much time for normal batch replication");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(100);
            scanner.close();
            if (res.length == 100) break;
            LOG.info("Only got " + res.length + " rows");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testDisableEnable() throws Exception {
        Result res;
        int i;
        admin.disablePeer("2");
        byte[] rowkey = Bytes.toBytes("disable enable");
        Put put = new Put(rowkey);
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowkey);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        admin.enablePeer("2");
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                return;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }

    @Test(timeout=300000L)
    public void testAddAndRemoveClusters() throws Exception {
        Result res;
        int i;
        LOG.info("testAddAndRemoveClusters");
        admin.removePeer("2");
        Thread.sleep(500L);
        byte[] rowKey = Bytes.toBytes("Won't be replicated");
        Put put = new Put(rowKey);
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowKey);
        for (i = 0; i < 10 && i != 9; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Not supposed to be replicated");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        admin.addPeer("2", utility2.getClusterKey());
        Thread.sleep(500L);
        rowKey = Bytes.toBytes("do rep");
        put = new Put(rowKey);
        put.add(famName, row, row);
        LOG.info("Adding new row");
        htable1.put(put);
        get = new Get(rowKey);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L * (long)i);
        }
    }

    @Test(timeout=300000L)
    public void testLoading() throws Exception {
        LOG.info("Writing out rows to table1 in testLoading");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 1000; ++i) {
            Put put = new Put(Bytes.toBytes(i));
            put.add(famName, row, row);
            puts.add(put);
        }
        htable1.setWriteBufferSize(1024L);
        htable1.put(puts);
        Scan scan = new Scan();
        ResultScanner scanner = htable1.getScanner(scan);
        Result[] res = scanner.next(1000);
        scanner.close();
        Assert.assertEquals((long)1000L, (long)res.length);
        LOG.info("Looking in table2 for replicated rows in testLoading");
        long start = System.currentTimeMillis();
        long retries = 100L;
        int i = 0;
        while ((long)i < 100L) {
            scan = new Scan();
            scanner = htable2.getScanner(scan);
            res = scanner.next(1000);
            scanner.close();
            if (res.length == 1000) break;
            if ((long)i == 99L) {
                int lastRow = -1;
                for (Result result : res) {
                    int currentRow = Bytes.toInt(result.getRow());
                    for (int row = lastRow + 1; row < currentRow; ++row) {
                        LOG.error("Row missing: " + row);
                    }
                    lastRow = currentRow;
                }
                LOG.error("Last row: " + lastRow);
                Assert.fail((String)("Waited too much time for normal batch replication, " + res.length + " instead of " + 1000 + "; waited=" + (System.currentTimeMillis() - start) + "ms"));
            } else {
                LOG.info("Only got " + res.length + " rows... retrying");
                Thread.sleep(500L);
            }
            ++i;
        }
    }

    @Test(timeout=300000L)
    public void testVerifyRepJob() throws Exception {
        this.testSmallBatch();
        String[] args = new String[]{"2", tableName.getNameAsString()};
        Job job = VerifyReplication.createSubmittableJob(CONF_WITH_LOCALFS, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Mutation put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            ((Put)put).add(CellUtil.cloneFamily(firstVal), CellUtil.cloneQualifier(firstVal), Bytes.toBytes("diff data"));
            htable2.put((Put)put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        job = VerifyReplication.createSubmittableJob(CONF_WITH_LOCALFS, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    @Test(timeout=300000L)
    public void testCompactionWALEdits() throws Exception {
        WALProtos.CompactionDescriptor compactionDescriptor = WALProtos.CompactionDescriptor.getDefaultInstance();
        HRegionInfo hri = new HRegionInfo(htable1.getName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        WALEdit edit = WALEdit.createCompaction(hri, compactionDescriptor);
        Replication.scopeWALEdits(htable1.getTableDescriptor(), new WALKey(), edit);
    }

    @Test(timeout=300000L)
    public void testVerifyListReplicatedTable() throws Exception {
        int i;
        LOG.info("testVerifyListReplicatedTable");
        String tName = "VerifyListReplicated_";
        String colFam = "cf1";
        int numOfTables = 3;
        HBaseAdmin hadmin = new HBaseAdmin(conf1);
        for (int i2 = 0; i2 < 3; ++i2) {
            HTableDescriptor ht = new HTableDescriptor(TableName.valueOf("VerifyListReplicated_" + i2));
            HColumnDescriptor cfd = new HColumnDescriptor("cf1");
            cfd.setScope(1);
            ht.addFamily(cfd);
            hadmin.createTable(ht);
        }
        List<HashMap<String, String>> replicationColFams = admin.listReplicated();
        int[] match = new int[3];
        for (i = 0; i < replicationColFams.size(); ++i) {
            int m;
            HashMap<String, String> replicationEntry = replicationColFams.get(i);
            String tn = replicationEntry.get("tableName");
            if (!tn.startsWith("VerifyListReplicated_") || !replicationEntry.get("columnFamlyName").equals("cf1")) continue;
            int n = m = Integer.parseInt(tn.substring(tn.length() - 1));
            match[n] = match[n] + 1;
        }
        for (i = 0; i < match.length; ++i) {
            Assert.assertTrue((String)("listReplicated() does not match table " + i), (match[i] == 1 ? 1 : 0) != 0);
        }
        for (i = 0; i < 3; ++i) {
            String ht = "VerifyListReplicated_" + i;
            hadmin.disableTable(ht);
            hadmin.deleteTable(ht);
        }
        hadmin.close();
    }

    @Test(timeout=300000L)
    public void testReplicationStatus() throws Exception {
        LOG.info("testReplicationStatus");
        try (Admin admin = utility1.getConnection().getAdmin();){
            byte[] qualName = Bytes.toBytes("q");
            for (int i = 0; i < 100; ++i) {
                Put p = new Put(Bytes.toBytes("row" + i));
                p.add(famName, qualName, Bytes.toBytes("val" + i));
                htable1.put(p);
            }
            ClusterStatus status2 = admin.getClusterStatus();
            for (ServerName server : status2.getServers()) {
                ServerLoad sl = status2.getLoad(server);
                List<ReplicationLoadSource> rLoadSourceList = sl.getReplicationLoadSourceList();
                ReplicationLoadSink rLoadSink = sl.getReplicationLoadSink();
                Assert.assertTrue((String)"failed to get ReplicationLoadSourceList", (rLoadSourceList.size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"failed to get ReplicationLoadSink.AgeOfLastShippedOp ", (rLoadSink.getAgeOfLastAppliedOp() >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)"failed to get ReplicationLoadSink.TimeStampsOfLastAppliedOp ", (rLoadSink.getTimeStampsOfLastAppliedOp() >= 0L ? 1 : 0) != 0);
            }
        }
    }
}

