/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterReplication {
    private static final Log LOG = LogFactory.getLog(TestReplicationBase.class);
    private Configuration baseConfiguration;
    private HBaseTestingUtility[] utilities;
    private Configuration[] configurations;
    private MiniZooKeeperCluster miniZK;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 10;
    private static final TableName tableName = TableName.valueOf("test");
    private static final byte[] famName = Bytes.toBytes("f");
    private static final byte[] row = Bytes.toBytes("row");
    private static final byte[] row1 = Bytes.toBytes("row1");
    private static final byte[] row2 = Bytes.toBytes("row2");
    private static final byte[] row3 = Bytes.toBytes("row3");
    private static final byte[] row4 = Bytes.toBytes("row4");
    private static final byte[] noRepfamName = Bytes.toBytes("norep");
    private static final byte[] count = Bytes.toBytes("count");
    private static final byte[] put = Bytes.toBytes("put");
    private static final byte[] delete = Bytes.toBytes("delete");
    private HTableDescriptor table;

    @Before
    public void setUp() throws Exception {
        this.baseConfiguration = HBaseConfiguration.create();
        this.baseConfiguration.setInt("hbase.regionserver.hlog.blocksize", 20480);
        this.baseConfiguration.setInt("replication.source.size.capacity", 1024);
        this.baseConfiguration.setLong("replication.source.sleepforretries", 100L);
        this.baseConfiguration.setInt("hbase.regionserver.maxlogs", 10);
        this.baseConfiguration.setLong("hbase.master.logcleaner.ttl", 10L);
        this.baseConfiguration.setBoolean("hbase.replication", true);
        this.baseConfiguration.setBoolean("dfs.support.append", true);
        this.baseConfiguration.setLong("hbase.server.thread.wakefrequency", 100L);
        this.baseConfiguration.setStrings("hbase.coprocessor.user.region.classes", new String[]{CoprocessorCounter.class.getName()});
        this.table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.table.addFamily(fam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCyclicReplication1() throws Exception {
        LOG.info("testSimplePutDelete");
        int numClusters = 2;
        Closeable[] htables = null;
        try {
            this.startMiniClusters(numClusters);
            this.createTableOnClusters(this.table);
            htables = this.getHTablesOnClusters(tableName);
            this.addPeer("1", 0, 1);
            this.addPeer("1", 1, 0);
            int[] expectedCounts = new int[]{2, 2};
            this.putAndWait(row, famName, htables[0], htables[1]);
            this.putAndWait(row1, famName, htables[1], htables[0]);
            this.validateCounts((Table[])htables, put, expectedCounts);
            this.deleteAndWait(row, htables[0], htables[1]);
            this.deleteAndWait(row1, htables[1], htables[0]);
            this.validateCounts((Table[])htables, delete, expectedCounts);
            this.close(htables);
        }
        catch (Throwable throwable) {
            this.close(htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCyclicReplication2() throws Exception {
        LOG.info("testCyclicReplication1");
        int numClusters = 3;
        Closeable[] htables = null;
        try {
            this.startMiniClusters(numClusters);
            this.createTableOnClusters(this.table);
            this.addPeer("1", 0, 1);
            this.addPeer("1", 1, 2);
            this.addPeer("1", 2, 0);
            htables = this.getHTablesOnClusters(tableName);
            this.putAndWait(row, famName, htables[0], htables[2]);
            this.putAndWait(row1, famName, htables[1], htables[0]);
            this.putAndWait(row2, famName, htables[2], htables[1]);
            this.deleteAndWait(row, htables[0], htables[2]);
            this.deleteAndWait(row1, htables[1], htables[0]);
            this.deleteAndWait(row2, htables[2], htables[1]);
            int[] expectedCounts = new int[]{3, 3, 3};
            this.validateCounts((Table[])htables, put, expectedCounts);
            this.validateCounts((Table[])htables, delete, expectedCounts);
            this.disablePeer("1", 2);
            this.putAndWait(row3, famName, htables[0], htables[1]);
            htables[1].put(new Put(row4).add(famName, row4, row4));
            this.enablePeer("1", 2);
            this.wait(row4, htables[0], true);
            this.close(htables);
        }
        catch (Throwable throwable) {
            this.close(htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCyclicReplication3() throws Exception {
        LOG.info("testCyclicReplication2");
        int numClusters = 3;
        Closeable[] htables = null;
        try {
            this.startMiniClusters(numClusters);
            this.createTableOnClusters(this.table);
            this.addPeer("1", 0, 1);
            this.addPeer("1", 1, 2);
            this.addPeer("1", 2, 1);
            htables = this.getHTablesOnClusters(tableName);
            this.putAndWait(row, famName, htables[0], htables[2]);
            this.putAndWait(row1, famName, htables[1], htables[2]);
            this.putAndWait(row2, famName, htables[2], htables[1]);
            this.deleteAndWait(row, htables[0], htables[2]);
            this.deleteAndWait(row1, htables[1], htables[2]);
            this.deleteAndWait(row2, htables[2], htables[1]);
            int[] expectedCounts = new int[]{1, 3, 3};
            this.validateCounts((Table[])htables, put, expectedCounts);
            this.validateCounts((Table[])htables, delete, expectedCounts);
            this.close(htables);
        }
        catch (Throwable throwable) {
            this.close(htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    @After
    public void tearDown() throws IOException {
        this.configurations = null;
        this.utilities = null;
    }

    private void startMiniClusters(int numClusters) throws Exception {
        Random random = new Random();
        this.utilities = new HBaseTestingUtility[numClusters];
        this.configurations = new Configuration[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            Configuration conf = new Configuration(this.baseConfiguration);
            conf.set("zookeeper.znode.parent", "/" + i + random.nextInt());
            HBaseTestingUtility utility = new HBaseTestingUtility(conf);
            if (i == 0) {
                utility.startMiniZKCluster();
                this.miniZK = utility.getZkCluster();
            } else {
                utility.setZkCluster(this.miniZK);
            }
            utility.startMiniCluster();
            this.utilities[i] = utility;
            this.configurations[i] = conf;
            new ZooKeeperWatcher(conf, "cluster" + i, null, true);
        }
    }

    private void shutDownMiniClusters() throws Exception {
        int numClusters = this.utilities.length;
        for (int i = numClusters - 1; i >= 0; --i) {
            if (this.utilities[i] == null) continue;
            this.utilities[i].shutdownMiniCluster();
        }
        this.miniZK.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableOnClusters(HTableDescriptor table) throws Exception {
        int numClusters = this.configurations.length;
        for (int i = 0; i < numClusters; ++i) {
            HBaseAdmin hbaseAdmin = null;
            try {
                hbaseAdmin = new HBaseAdmin(this.configurations[i]);
                hbaseAdmin.createTable(table);
            }
            catch (Throwable throwable) {
                this.close(hbaseAdmin);
                throw throwable;
            }
            this.close(hbaseAdmin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPeer(String id, int masterClusterNumber, int slaveClusterNumber) throws Exception {
        ReplicationAdmin replicationAdmin = null;
        try {
            replicationAdmin = new ReplicationAdmin(this.configurations[masterClusterNumber]);
            replicationAdmin.addPeer(id, this.utilities[slaveClusterNumber].getClusterKey());
        }
        catch (Throwable throwable) {
            this.close(replicationAdmin);
            throw throwable;
        }
        this.close(replicationAdmin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disablePeer(String id, int masterClusterNumber) throws Exception {
        ReplicationAdmin replicationAdmin = null;
        try {
            replicationAdmin = new ReplicationAdmin(this.configurations[masterClusterNumber]);
            replicationAdmin.disablePeer(id);
        }
        catch (Throwable throwable) {
            this.close(replicationAdmin);
            throw throwable;
        }
        this.close(replicationAdmin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enablePeer(String id, int masterClusterNumber) throws Exception {
        ReplicationAdmin replicationAdmin = null;
        try {
            replicationAdmin = new ReplicationAdmin(this.configurations[masterClusterNumber]);
            replicationAdmin.enablePeer(id);
        }
        catch (Throwable throwable) {
            this.close(replicationAdmin);
            throw throwable;
        }
        this.close(replicationAdmin);
    }

    private void close(Closeable ... closeables) {
        try {
            if (closeables != null) {
                for (Closeable closeable : closeables) {
                    closeable.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception occured while closing the object:", e);
        }
    }

    private Table[] getHTablesOnClusters(TableName tableName) throws Exception {
        int numClusters = this.utilities.length;
        Table[] htables = new Table[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            HTable htable = new HTable(this.configurations[i], tableName);
            htable.setWriteBufferSize(1024L);
            htables[i] = htable;
        }
        return htables;
    }

    private void validateCounts(Table[] htables, byte[] type, int[] expectedCounts) throws IOException {
        for (int i = 0; i < htables.length; ++i) {
            Assert.assertEquals((String)(Bytes.toString(type) + " were replicated back "), (long)expectedCounts[i], (long)this.getCount(htables[i], type));
        }
    }

    private int getCount(Table t, byte[] type) throws IOException {
        Get test = new Get(row);
        test.setAttribute("count", new byte[0]);
        Result res = t.get(test);
        return Bytes.toInt(res.getValue(count, type));
    }

    private void deleteAndWait(byte[] row, Table source, Table target) throws Exception {
        Delete del = new Delete(row);
        source.delete(del);
        this.wait(row, target, true);
    }

    private void putAndWait(byte[] row, byte[] fam, Table source, Table target) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, row);
        source.put(put);
        this.wait(row, target, false);
    }

    private void wait(byte[] row, Table target, boolean isDeleted) throws Exception {
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            boolean sleep;
            if (i == 9) {
                Assert.fail((String)("Waited too much time for replication. Row:" + Bytes.toString(row) + ". IsDeleteReplication:" + isDeleted));
            }
            Result res = target.get(get);
            boolean bl = isDeleted ? res.size() > 0 : (sleep = res.size() == 0);
            if (!sleep) {
                if (!isDeleted) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                }
                LOG.info("Obtained row:" + Bytes.toString(row) + ". IsDeleteReplication:" + isDeleted);
                break;
            }
            LOG.info("Waiting for more time for replication. Row:" + Bytes.toString(row) + ". IsDeleteReplication:" + isDeleted);
            Thread.sleep(500L);
        }
    }

    public static class CoprocessorCounter
    extends BaseRegionObserver {
        private int nCount = 0;
        private int nDelete = 0;

        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            ++this.nCount;
        }

        @Override
        public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
            ++this.nDelete;
        }

        @Override
        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            if (get.getAttribute("count") != null) {
                result.clear();
                result.add(new KeyValue(count, count, delete, Bytes.toBytes(this.nDelete)));
                result.add(new KeyValue(count, count, put, Bytes.toBytes(this.nCount)));
                c.bypass();
            }
        }
    }
}

