/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReadOldRootAndMetaEdits {
    private static final Log LOG = LogFactory.getLog(TestReadOldRootAndMetaEdits.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static FileSystem fs;
    private static Path dir;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.regionserver.hlog.writer.impl", SequenceFileLogWriter.class, WALProvider.Writer.class);
        fs = TEST_UTIL.getTestFileSystem();
        dir = new Path(TEST_UTIL.createRootDir(), "testReadOldRootAndMetaEdits");
        fs.mkdirs(dir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadOldRootAndMetaEdits() throws IOException {
        LOG.debug("testReadOldRootAndMetaEdits");
        byte[] row = Bytes.toBytes("row");
        KeyValue kv = new KeyValue(row, row, row, row);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(kv);
        Closeable writer = null;
        Closeable reader = null;
        TableName t = TableName.valueOf("t");
        HRegionInfo tRegionInfo = null;
        int logCount = 0;
        long timestamp = System.currentTimeMillis();
        Path path = new Path(dir, "t");
        try {
            tRegionInfo = new HRegionInfo(t, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            WAL.Entry tEntry = this.createAEntry(new HLogKey(tRegionInfo.getEncodedNameAsBytes(), t, (long)(++logCount), timestamp, HConstants.DEFAULT_CLUSTER_ID), kvs);
            WAL.Entry rootEntry = this.createAEntry(new HLogKey(Bytes.toBytes("-ROOT-"), TableName.OLD_ROOT_TABLE_NAME, (long)(++logCount), timestamp, HConstants.DEFAULT_CLUSTER_ID), kvs);
            WAL.Entry oldMetaEntry = this.createAEntry(new HLogKey(Bytes.toBytes(".META."), TableName.OLD_META_TABLE_NAME, (long)(++logCount), timestamp, HConstants.DEFAULT_CLUSTER_ID), kvs);
            writer = WALFactory.createWALWriter(fs, path, conf);
            writer.append(tEntry);
            writer.append(rootEntry);
            writer.append(oldMetaEntry);
            writer.sync();
            writer.close();
            reader = WALFactory.createReader(fs, path, conf);
            WAL.Entry entry = reader.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertTrue((boolean)entry.getKey().getTablename().equals(t));
            Assert.assertEquals((Object)Bytes.toString(entry.getKey().getEncodedRegionName()), (Object)Bytes.toString(tRegionInfo.getEncodedNameAsBytes()));
            entry = reader.next();
            Assert.assertEquals((Object)entry.getKey().getTablename(), (Object)TableName.META_TABLE_NAME);
            Assert.assertNull((Object)reader.next());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private WAL.Entry createAEntry(WALKey walKey, List<KeyValue> kvs) {
        WALEdit edit = new WALEdit();
        for (KeyValue kv : kvs) {
            edit.add(kv);
        }
        return new WAL.Entry(walKey, edit);
    }
}

