/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class StripeCompactor
extends Compactor {
    private static final Log LOG = LogFactory.getLog(StripeCompactor.class);

    public StripeCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    public List<Path> compact(CompactionRequest request, List<byte[]> targetBoundaries, byte[] majorRangeFromRow, byte[] majorRangeToRow, CompactionThroughputController throughputController) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Executing compaction with " + targetBoundaries.size() + " boundaries:");
            for (byte[] tb : targetBoundaries) {
                sb.append(" [").append(Bytes.toString(tb)).append("]");
            }
            LOG.debug(sb.toString());
        }
        StripeMultiFileWriter.BoundaryMultiWriter writer = new StripeMultiFileWriter.BoundaryMultiWriter(targetBoundaries, majorRangeFromRow, majorRangeToRow);
        return this.compactInternal(writer, request, majorRangeFromRow, majorRangeToRow, throughputController);
    }

    public List<Path> compact(CompactionRequest request, int targetCount, long targetSize, byte[] left, byte[] right, byte[] majorRangeFromRow, byte[] majorRangeToRow, CompactionThroughputController throughputController) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing compaction with " + targetSize + " target file size, no more than " + targetCount + " files, in [" + Bytes.toString(left) + "] [" + Bytes.toString(right) + "] range");
        }
        StripeMultiFileWriter.SizeMultiWriter writer = new StripeMultiFileWriter.SizeMultiWriter(targetCount, targetSize, left, right);
        return this.compactInternal(writer, request, majorRangeFromRow, majorRangeToRow, throughputController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> compactInternal(StripeMultiFileWriter mw, CompactionRequest request, byte[] majorRangeFromRow, byte[] majorRangeToRow, CompactionThroughputController throughputController) throws IOException {
        Collection<StoreFile> filesToCompact = request.getFiles();
        final Compactor.FileDetails fd = this.getFileDetails(filesToCompact, request.isMajor());
        this.progress = new CompactionProgress(fd.maxKeyCount);
        long smallestReadPoint = this.getSmallestReadPoint();
        List<StoreFileScanner> scanners = this.createFileScanners(filesToCompact, smallestReadPoint);
        boolean finished = false;
        InternalScanner scanner = null;
        boolean cleanSeqId = false;
        try {
            ScanType coprocScanType = ScanType.COMPACT_RETAIN_DELETES;
            scanner = this.preCreateCoprocScanner(request, coprocScanType, fd.earliestPutTs, scanners);
            if (scanner == null) {
                InternalScanner internalScanner = scanner = majorRangeFromRow == null ? this.createScanner(this.store, scanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, fd.earliestPutTs) : this.createScanner(this.store, scanners, smallestReadPoint, fd.earliestPutTs, majorRangeFromRow, majorRangeToRow);
            }
            if ((scanner = this.postCreateCoprocScanner(request, coprocScanType, scanner)) == null) {
                ArrayList<Path> arrayList = new ArrayList<Path>();
                return arrayList;
            }
            if (fd.minSeqIdToKeep > 0L) {
                smallestReadPoint = Math.min(fd.minSeqIdToKeep, smallestReadPoint);
                cleanSeqId = true;
            }
            final boolean needMvcc = fd.maxMVCCReadpoint > 0L;
            final Compression.Algorithm compression = this.store.getFamily().getCompactionCompression();
            StripeMultiFileWriter.WriterFactory factory = new StripeMultiFileWriter.WriterFactory(){

                @Override
                public StoreFile.Writer createWriter() throws IOException {
                    return StripeCompactor.this.store.createWriterInTmp(fd.maxKeyCount, compression, true, needMvcc, fd.maxTagsLength > 0);
                }
            };
            StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
            mw.init(storeScanner, factory, this.store.getComparator());
            finished = this.performCompaction(scanner, mw, smallestReadPoint, cleanSeqId, throughputController);
            if (!finished) {
                throw new InterruptedIOException("Aborting compaction of store " + this.store + " in region " + this.store.getRegionInfo().getRegionNameAsString() + " because it was interrupted.");
            }
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Throwable t) {
                    LOG.error("Failed to close scanner after compaction.", t);
                }
            }
            if (!finished) {
                for (Path leftoverFile : mw.abortWriters()) {
                    try {
                        this.store.getFileSystem().delete(leftoverFile, false);
                    }
                    catch (Exception ex) {
                        LOG.error("Failed to delete the leftover file after an unfinished compaction.", ex);
                    }
                }
            }
        }
        assert (finished) : "We should have exited the method on all error paths";
        List<Path> newFiles = mw.commitWriters(fd.maxSeqId, request.isMajor());
        assert (!newFiles.isEmpty()) : "Should have produced an empty file to preserve metadata.";
        return newFiles;
    }
}

