/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.base.Objects;
import org.apache.hive.org.apache.commons.lang.RandomStringUtils;
import org.mockito.Mockito;

class MockStoreFileGenerator {
    private static final int FILENAME_LENGTH = 10;
    protected Random random;

    MockStoreFileGenerator(Class klass) {
        this.random = new Random(klass.getSimpleName().hashCode());
    }

    protected List<StoreFile> createStoreFileList(int[] fs) {
        LinkedList<StoreFile> storeFiles = new LinkedList<StoreFile>();
        for (int fileSize : fs) {
            storeFiles.add(this.createMockStoreFile(fileSize));
        }
        return storeFiles;
    }

    protected StoreFile createMockStoreFile(long size) {
        return this.createMockStoreFile(size * 1024L * 1024L, -1L);
    }

    protected StoreFile createMockStoreFileBytes(long size) {
        return this.createMockStoreFile(size, -1L);
    }

    protected StoreFile createMockStoreFile(long sizeInBytes, long seqId) {
        StoreFile mockSf = (StoreFile)Mockito.mock(StoreFile.class);
        StoreFile.Reader reader = (StoreFile.Reader)Mockito.mock(StoreFile.Reader.class);
        String stringPath = "/hbase/testTable/regionA/" + RandomStringUtils.random(10, 0, 0, true, true, null, this.random);
        Path path = new Path(stringPath);
        Mockito.when((Object)reader.getSequenceID()).thenReturn((Object)seqId);
        Mockito.when((Object)reader.getTotalUncompressedBytes()).thenReturn((Object)sizeInBytes);
        Mockito.when((Object)reader.length()).thenReturn((Object)sizeInBytes);
        Mockito.when((Object)mockSf.getPath()).thenReturn((Object)path);
        Mockito.when((Object)mockSf.excludeFromMinorCompaction()).thenReturn((Object)false);
        Mockito.when((Object)mockSf.isReference()).thenReturn((Object)false);
        Mockito.when((Object)mockSf.getReader()).thenReturn((Object)reader);
        String toString = Objects.toStringHelper("MockStoreFile").add("isReference", false).add("fileSize", StringUtils.humanReadableInt((long)sizeInBytes)).add("seqId", seqId).add("path", stringPath).toString();
        Mockito.when((Object)mockSf.toString()).thenReturn((Object)toString);
        return mockSf;
    }
}

