/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hive.com.google.common.base.Joiner;
import org.apache.hive.com.google.common.collect.Iterables;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestStoreFile
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestStoreFile.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
    private static String ROOT_DIR = TEST_UTIL.getDataTestDir("TestStoreFile").toString();
    private static final ChecksumType CKTYPE = ChecksumType.CRC32;
    private static final int CKBYTES = 512;
    private static String TEST_FAMILY = "cf";
    byte[] SPLITKEY = new byte[]{109, 97};
    private static final String localFormatter = "%010d";
    private static final int BLOCKSIZE_SMALL = 8192;

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasicHalfMapFile() throws Exception {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("testBasicHalfMapFileTb"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(this.conf, this.fs, new Path(testDir, hri.getTable().getNameAsString()), hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path sfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        StoreFile sf = new StoreFile(this.fs, sfPath, this.conf, this.cacheConf, BloomType.NONE);
        this.checkHalfHFile(regionFs, sf);
    }

    private void writeStoreFile(StoreFile.Writer writer) throws IOException {
        TestStoreFile.writeStoreFile(writer, Bytes.toBytes(this.getName()), Bytes.toBytes(this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStoreFile(StoreFile.Writer writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = System.currentTimeMillis();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append(new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public void testReference() throws IOException {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("testReferenceTb"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(this.conf, this.fs, new Path(testDir, hri.getTable().getNameAsString()), hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path hsfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        StoreFile hsf = new StoreFile(this.fs, hsfPath, this.conf, this.cacheConf, BloomType.NONE);
        StoreFile.Reader reader = hsf.createReader();
        KeyValue kv = KeyValue.createKeyValueFromKey(reader.midkey());
        byte[] midRow = kv.getRow();
        kv = KeyValue.createKeyValueFromKey(reader.getLastKey());
        byte[] finalRow = kv.getRow();
        HRegionInfo splitHri = new HRegionInfo(hri.getTable(), null, midRow);
        Path refPath = this.splitStoreFile(regionFs, splitHri, TEST_FAMILY, hsf, midRow, true);
        StoreFile refHsf = new StoreFile(this.fs, refPath, this.conf, this.cacheConf, BloomType.NONE);
        HFileScanner s = refHsf.createReader().getScanner(false, false);
        boolean first = true;
        while (!s.isSeeked() && s.seekTo() || s.next()) {
            ByteBuffer bb = s.getKey();
            kv = KeyValue.createKeyValueFromKey(bb);
            if (!first) continue;
            TestStoreFile.assertTrue((boolean)Bytes.equals(kv.getRow(), midRow));
            first = false;
        }
        TestStoreFile.assertTrue((boolean)Bytes.equals(kv.getRow(), finalRow));
    }

    public void testHFileLink() throws IOException {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("testHFileLinkTb"));
        Configuration testConf = new Configuration(this.conf);
        FSUtils.setRootDir(testConf, testDir);
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(testConf, this.fs, FSUtils.getTableDir(testDir, hri.getTable()), hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path storeFilePath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        Path dstPath = new Path(regionFs.getTableDir(), new Path("test-region", TEST_FAMILY));
        HFileLink.create(testConf, this.fs, dstPath, hri, storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName(hri, storeFilePath.getName()));
        StoreFileInfo storeFileInfo = new StoreFileInfo(testConf, this.fs, linkFilePath);
        StoreFile hsf = new StoreFile(this.fs, storeFileInfo, testConf, this.cacheConf, BloomType.NONE);
        TestStoreFile.assertTrue((boolean)storeFileInfo.isLink());
        int count = 1;
        HFileScanner s = hsf.createReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        TestStoreFile.assertEquals((int)676, (int)count);
    }

    public void testReferenceToHFileLink() throws IOException {
        Configuration testConf = new Configuration(this.conf);
        FSUtils.setRootDir(testConf, testDir);
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("_original-evil-name"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(testConf, this.fs, FSUtils.getTableDir(testDir, hri.getTable()), hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(testConf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path storeFilePath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        HRegionInfo hriClone = new HRegionInfo(TableName.valueOf("clone"));
        HRegionFileSystem cloneRegionFs = HRegionFileSystem.createRegionOnFileSystem(testConf, this.fs, FSUtils.getTableDir(testDir, hri.getTable()), hriClone);
        Path dstPath = cloneRegionFs.getStoreDir(TEST_FAMILY);
        HFileLink.create(testConf, this.fs, dstPath, hri, storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName(hri, storeFilePath.getName()));
        HRegionInfo splitHriA = new HRegionInfo(hri.getTable(), null, this.SPLITKEY);
        HRegionInfo splitHriB = new HRegionInfo(hri.getTable(), this.SPLITKEY, null);
        StoreFile f = new StoreFile(this.fs, linkFilePath, testConf, this.cacheConf, BloomType.NONE);
        Path pathA = this.splitStoreFile(cloneRegionFs, splitHriA, TEST_FAMILY, f, this.SPLITKEY, true);
        Path pathB = this.splitStoreFile(cloneRegionFs, splitHriB, TEST_FAMILY, f, this.SPLITKEY, false);
        FSUtils.logFileSystemState(this.fs, testDir, LOG);
        StoreFile hsfA = new StoreFile(this.fs, pathA, testConf, this.cacheConf, BloomType.NONE);
        int count = 1;
        HFileScanner s = hsfA.createReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        TestStoreFile.assertTrue((count > 0 ? 1 : 0) != 0);
        StoreFile hsfB = new StoreFile(this.fs, pathB, testConf, this.cacheConf, BloomType.NONE);
        HFileScanner sB = hsfB.createReader().getScanner(false, false);
        sB.seekTo();
        ++count;
        while (sB.next()) {
            ++count;
        }
        TestStoreFile.assertEquals((int)676, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHalfHFile(HRegionFileSystem regionFs, StoreFile f) throws IOException {
        byte[] midkey = f.createReader().midkey();
        KeyValue midKV = KeyValue.createKeyValueFromKey(midkey);
        byte[] midRow = midKV.getRow();
        HRegionInfo topHri = new HRegionInfo(regionFs.getRegionInfo().getTable(), null, midRow);
        Path topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, midRow, true);
        HRegionInfo bottomHri = new HRegionInfo(regionFs.getRegionInfo().getTable(), midRow, null);
        Path bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, midRow, false);
        StoreFile.Reader top = new StoreFile(this.fs, topPath, this.conf, this.cacheConf, BloomType.NONE).createReader();
        StoreFile.Reader bottom = new StoreFile(this.fs, bottomPath, this.conf, this.cacheConf, BloomType.NONE).createReader();
        ByteBuffer previous = null;
        LOG.info("Midkey: " + midKV.toString());
        ByteBuffer bbMidkeyBytes = ByteBuffer.wrap(midkey);
        try {
            int i;
            String tmp;
            KeyValue keyKV;
            boolean first = true;
            ByteBuffer key = null;
            HFileScanner topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                key = topScanner.getKey();
                if (topScanner.getReader().getComparator().compareFlatKey(key.array(), key.arrayOffset(), key.limit(), midkey, 0, midkey.length) < 0) {
                    TestStoreFile.fail((String)("key=" + Bytes.toStringBinary(key) + " < midkey=" + Bytes.toStringBinary(midkey)));
                }
                if (!first) continue;
                first = false;
                LOG.info("First in top: " + Bytes.toString(Bytes.toBytes(key)));
            }
            LOG.info("Last in top: " + Bytes.toString(Bytes.toBytes(key)));
            first = true;
            HFileScanner bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                previous = bottomScanner.getKey();
                key = bottomScanner.getKey();
                if (first) {
                    first = false;
                    LOG.info("First in bottom: " + Bytes.toString(Bytes.toBytes(previous)));
                }
                TestStoreFile.assertTrue((key.compareTo(bbMidkeyBytes) < 0 ? 1 : 0) != 0);
            }
            if (previous != null) {
                LOG.info("Last in bottom: " + Bytes.toString(Bytes.toBytes(previous)));
            }
            regionFs.cleanupDaughterRegion(topHri);
            regionFs.cleanupDaughterRegion(bottomHri);
            byte[] badmidkey = Bytes.toBytes("  .");
            TestStoreFile.assertTrue((boolean)this.fs.exists(f.getPath()));
            topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, badmidkey, true);
            bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, badmidkey, false);
            TestStoreFile.assertNull((Object)bottomPath);
            top = new StoreFile(this.fs, topPath, this.conf, this.cacheConf, BloomType.NONE).createReader();
            first = true;
            topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.next()) {
                key = topScanner.getKey();
                TestStoreFile.assertTrue((topScanner.getReader().getComparator().compareFlatKey(key.array(), key.arrayOffset(), key.limit(), badmidkey, 0, badmidkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                keyKV = KeyValue.createKeyValueFromKey(key);
                LOG.info("First top when key < bottom: " + keyKV);
                tmp = Bytes.toString(keyKV.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValue.createKeyValueFromKey(key);
            LOG.info("Last top when key < bottom: " + keyKV);
            tmp = Bytes.toString(keyKV.getRow());
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((tmp.charAt(i) == 'z' ? 1 : 0) != 0);
            }
            regionFs.cleanupDaughterRegion(topHri);
            regionFs.cleanupDaughterRegion(bottomHri);
            badmidkey = Bytes.toBytes("|||");
            topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, badmidkey, true);
            bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, badmidkey, false);
            TestStoreFile.assertNull((Object)topPath);
            bottom = new StoreFile(this.fs, bottomPath, this.conf, this.cacheConf, BloomType.NONE).createReader();
            first = true;
            bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                key = bottomScanner.getKey();
                if (!first) continue;
                first = false;
                keyKV = KeyValue.createKeyValueFromKey(key);
                LOG.info("First bottom when key > top: " + keyKV);
                tmp = Bytes.toString(keyKV.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValue.createKeyValueFromKey(key);
            LOG.info("Last bottom when key > top: " + keyKV);
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((Bytes.toString(keyKV.getRow()).charAt(i) == 'z' ? 1 : 0) != 0);
            }
        }
        finally {
            if (top != null) {
                top.close(true);
            }
            if (bottom != null) {
                bottom.close(true);
            }
            this.fs.delete(f.getPath(), true);
        }
    }

    private void bloomWriteRead(StoreFile.Writer writer, FileSystem fs) throws Exception {
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = writer.getPath();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), "col".getBytes(), now, "value".getBytes());
            writer.append(kv);
        }
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader(fs, f, this.cacheConf, this.conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            columns.add("family:col".getBytes());
            Scan scan = new Scan(row.getBytes(), row.getBytes());
            scan.addColumn("family".getBytes(), "family:col".getBytes());
            boolean exists = scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close(true);
        fs.delete(f, true);
        TestStoreFile.assertEquals((String)("False negatives: " + falseNeg), (int)0, (int)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        TestStoreFile.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos + ")"), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    public void testBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(f).withBloomType(BloomType.ROW).withMaxKeyCount(2000L).withFileContext(meta).build();
        this.bloomWriteRead(writer, (FileSystem)fs);
    }

    public void testDeleteFamilyBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(f).withMaxKeyCount(2000L).withFileContext(meta).build();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), "col".getBytes(), now, KeyValue.Type.DeleteFamily, "value".getBytes());
            writer.append(kv);
        }
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader((FileSystem)fs, f, this.cacheConf, this.conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            byte[] rowKey = Bytes.toBytes(row);
            boolean exists = reader.passesDeleteFamilyBloomFilter(rowKey, 0, rowKey.length);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        TestStoreFile.assertEquals((long)1000L, (long)reader.getDeleteFamilyCnt());
        reader.close(true);
        fs.delete(f, true);
        TestStoreFile.assertEquals((String)("False negatives: " + falseNeg), (int)0, (int)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        TestStoreFile.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    public void testReseek() throws Exception {
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(f).withFileContext(meta).build();
        this.writeStoreFile(writer);
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader(this.fs, f, this.cacheConf, this.conf);
        KeyValue k = KeyValueUtil.createFirstOnRow(HConstants.EMPTY_BYTE_ARRAY);
        StoreFileScanner s = reader.getStoreFileScanner(false, false);
        s.reseek(k);
        TestStoreFile.assertNotNull((String)"Intial reseek should position at the beginning of the file", (Object)s.peek());
    }

    public void testBloomTypes() throws Exception {
        float err = 0.01f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        int rowCount = 50;
        int colCount = 10;
        int versions = 2;
        BloomType[] bt = new BloomType[]{BloomType.ROWCOL, BloomType.ROW};
        int[] expKeys = new int[]{rowCount * colCount, rowCount};
        float[] expErr = new float[]{(float)(2 * rowCount * colCount) * err, (float)(2 * rowCount * 2 * colCount) * err};
        for (int x : new int[]{0, 1}) {
            Path f = new Path(ROOT_DIR, this.getName() + x);
            HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
            StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(f).withBloomType(bt[x]).withMaxKeyCount(expKeys[x]).withFileContext(meta).build();
            long now = System.currentTimeMillis();
            for (int i = 0; i < rowCount * 2; i += 2) {
                for (int j = 0; j < colCount * 2; j += 2) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    for (int k = 0; k < versions; ++k) {
                        KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), ("col" + col).getBytes(), now - (long)k, Bytes.toBytes(-1L));
                        writer.append(kv);
                    }
                }
            }
            writer.close();
            StoreFile.Reader reader = new StoreFile.Reader((FileSystem)fs, f, this.cacheConf, this.conf);
            reader.loadFileInfo();
            reader.loadBloomfilter();
            StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
            TestStoreFile.assertEquals((long)expKeys[x], (long)reader.generalBloomFilter.getKeyCount());
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < rowCount * 2; ++i) {
                for (int j = 0; j < colCount * 2; ++j) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                    columns.add(("col" + col).getBytes());
                    Scan scan = new Scan(row.getBytes(), row.getBytes());
                    scan.addColumn("family".getBytes(), ("col" + col).getBytes());
                    boolean exists = scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE);
                    boolean shouldRowExist = i % 2 == 0;
                    boolean shouldColExist = j % 2 == 0;
                    boolean bl = shouldColExist = shouldColExist || bt[x] == BloomType.ROW;
                    if (shouldRowExist && shouldColExist) {
                        if (exists) continue;
                        ++falseNeg;
                        continue;
                    }
                    if (!exists) continue;
                    ++falsePos;
                }
            }
            reader.close(true);
            fs.delete(f, true);
            System.out.println(bt[x].toString());
            System.out.println("  False negatives: " + falseNeg);
            System.out.println("  False positives: " + falsePos);
            TestStoreFile.assertEquals((int)0, (int)falseNeg);
            TestStoreFile.assertTrue(((float)falsePos < 2.0f * expErr[x] ? 1 : 0) != 0);
        }
    }

    public void testSeqIdComparator() {
        this.assertOrdering(StoreFile.Comparators.SEQ_ID, this.mockStoreFile(true, 100L, 1000L, -1L, "/foo/123"), this.mockStoreFile(true, 100L, 1000L, -1L, "/foo/124"), this.mockStoreFile(true, 99L, 1000L, -1L, "/foo/126"), this.mockStoreFile(true, 98L, 2000L, -1L, "/foo/126"), this.mockStoreFile(false, 3453L, -1L, 1L, "/foo/1"), this.mockStoreFile(false, 2L, -1L, 3L, "/foo/2"), this.mockStoreFile(false, 1000L, -1L, 5L, "/foo/2"), this.mockStoreFile(false, 76L, -1L, 5L, "/foo/3"));
    }

    private void assertOrdering(Comparator<StoreFile> comparator, StoreFile ... sfs) {
        ArrayList<StoreFile> sorted = Lists.newArrayList(sfs);
        Collections.shuffle(sorted);
        Collections.sort(sorted, comparator);
        LOG.debug("sfs: " + Joiner.on(",").join(sfs));
        LOG.debug("sorted: " + Joiner.on(",").join(sorted));
        TestStoreFile.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(sfs), sorted));
    }

    private StoreFile mockStoreFile(boolean bulkLoad, long size, long bulkTimestamp, long seqId, String path) {
        StoreFile mock = (StoreFile)Mockito.mock(StoreFile.class);
        StoreFile.Reader reader = (StoreFile.Reader)Mockito.mock(StoreFile.Reader.class);
        ((StoreFile.Reader)Mockito.doReturn((Object)size).when((Object)reader)).length();
        ((StoreFile)Mockito.doReturn((Object)reader).when((Object)mock)).getReader();
        ((StoreFile)Mockito.doReturn((Object)bulkLoad).when((Object)mock)).isBulkLoadResult();
        ((StoreFile)Mockito.doReturn((Object)bulkTimestamp).when((Object)mock)).getBulkLoadTimestamp();
        ((StoreFile)Mockito.doReturn((Object)seqId).when((Object)mock)).getMaxSequenceId();
        ((StoreFile)Mockito.doReturn((Object)new Path(path)).when((Object)mock)).getPath();
        String name = "mock storefile, bulkLoad=" + bulkLoad + " bulkTimestamp=" + bulkTimestamp + " seqId=" + seqId + " path=" + path;
        ((StoreFile)Mockito.doReturn((Object)name).when((Object)mock)).toString();
        return mock;
    }

    List<KeyValue> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes(i);
            LOG.info(Bytes.toString(b));
            LOG.info(Bytes.toString(b));
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    public void testMultipleTimestamps() throws IOException {
        byte[] family = Bytes.toBytes("familyname");
        byte[] qualifier = Bytes.toBytes("qualifier");
        int numRows = 10;
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        Path storedir = new Path(new Path(testDir, "7e0102"), "familyname");
        Path dir = new Path(storedir, "1234567890");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withOutputDir(dir).withFileContext(meta).build();
        List<KeyValue> kvList = this.getKeyValueSet(timestamps, numRows, family, qualifier);
        for (KeyValue kv : kvList) {
            writer.append(kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE);
        StoreFile.Reader reader = hsf.createReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qualifier);
        scan.setTimeRange(20L, 100L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(1L, 2L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(8L, 10L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(7L, 50L);
        TestStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE));
        scan.setTimeRange(27L, 50L);
        TestStoreFile.assertTrue((!scanner.shouldUseScanner(scan, columns, Long.MIN_VALUE) ? 1 : 0) != 0);
    }

    public void testCacheOnWriteEvictOnClose() throws Exception {
        Configuration conf = this.conf;
        Path baseDir = new Path(new Path(testDir, "7e0102"), "twoCOWEOC");
        BlockCache bc = new CacheConfig(conf).getBlockCache();
        TestStoreFile.assertNotNull((Object)bc);
        CacheStats cs = bc.getStats();
        long startHit = cs.getHitCount();
        long startMiss = cs.getMissCount();
        long startEvicted = cs.getEvictedCount();
        conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        CacheConfig cacheConf = new CacheConfig(conf);
        Path pathCowOff = new Path(baseDir, "123456789");
        StoreFile.Writer writer = this.writeStoreFile(conf, cacheConf, pathCowOff, 3);
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), conf, cacheConf, BloomType.NONE);
        LOG.debug(hsf.getPath().toString());
        StoreFile.Reader reader = hsf.createReader();
        reader.loadFileInfo();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, true);
        scanner.seek(KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        TestStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)(startMiss + 3L), (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startMiss += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        cacheConf = new CacheConfig(conf);
        Path pathCowOn = new Path(baseDir, "123456788");
        writer = this.writeStoreFile(conf, cacheConf, pathCowOn, 3);
        hsf = new StoreFile(this.fs, writer.getPath(), conf, cacheConf, BloomType.NONE);
        reader = hsf.createReader();
        scanner = reader.getStoreFileScanner(true, true);
        scanner.seek(KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        TestStoreFile.assertEquals((long)(startHit + 3L), (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        hsf = new StoreFile(this.fs, pathCowOff, conf, cacheConf, BloomType.NONE);
        StoreFile.Reader readerOne = hsf.createReader();
        readerOne.loadFileInfo();
        StoreFileScanner scannerOne = readerOne.getStoreFileScanner(true, true);
        scannerOne.seek(KeyValue.LOWESTKEY);
        hsf = new StoreFile(this.fs, pathCowOn, conf, cacheConf, BloomType.NONE);
        StoreFile.Reader readerTwo = hsf.createReader();
        readerTwo.loadFileInfo();
        StoreFileScanner scannerTwo = readerTwo.getStoreFileScanner(true, true);
        scannerTwo.seek(KeyValue.LOWESTKEY);
        Cell kv1 = null;
        Cell kv2 = null;
        while ((kv1 = scannerOne.next()) != null) {
            kv2 = scannerTwo.next();
            TestStoreFile.assertTrue((boolean)kv1.equals(kv2));
            KeyValue keyv1 = KeyValueUtil.ensureKeyValue(kv1);
            KeyValue keyv2 = KeyValueUtil.ensureKeyValue(kv2);
            TestStoreFile.assertTrue((Bytes.compareTo(keyv1.getBuffer(), keyv1.getKeyOffset(), keyv1.getKeyLength(), keyv2.getBuffer(), keyv2.getKeyOffset(), keyv2.getKeyLength()) == 0 ? 1 : 0) != 0);
            TestStoreFile.assertTrue((Bytes.compareTo(kv1.getValueArray(), kv1.getValueOffset(), kv1.getValueLength(), kv2.getValueArray(), kv2.getValueOffset(), kv2.getValueLength()) == 0 ? 1 : 0) != 0);
        }
        TestStoreFile.assertNull((Object)scannerTwo.next());
        TestStoreFile.assertEquals((long)(startHit + 6L), (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 6L;
        scannerOne.close();
        readerOne.close(cacheConf.shouldEvictOnClose());
        scannerTwo.close();
        readerTwo.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        cacheConf = new CacheConfig(conf);
        hsf = new StoreFile(this.fs, pathCowOff, conf, cacheConf, BloomType.NONE);
        reader = hsf.createReader();
        reader.close(cacheConf.shouldEvictOnClose());
        TestStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)(startEvicted + 3L), (long)cs.getEvictedCount());
        startEvicted += 3L;
        conf.setBoolean("hbase.rs.evictblocksonclose", false);
        cacheConf = new CacheConfig(conf);
        hsf = new StoreFile(this.fs, pathCowOn, conf, cacheConf, BloomType.NONE);
        reader = hsf.createReader();
        reader.close(cacheConf.shouldEvictOnClose());
        TestStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
    }

    private Path splitStoreFile(HRegionFileSystem regionFs, HRegionInfo hri, String family, StoreFile sf, byte[] splitKey, boolean isTopRef) throws IOException {
        FileSystem fs = regionFs.getFileSystem();
        Path path = regionFs.splitStoreFile(hri, family, sf, splitKey, isTopRef, null);
        if (null == path) {
            return null;
        }
        Path regionDir = regionFs.commitDaughterRegion(hri);
        return new Path(new Path(regionDir, family), path.getName());
    }

    private StoreFile.Writer writeStoreFile(Configuration conf, CacheConfig cacheConf, Path path, int numBlocks) throws IOException {
        int numKVs = 5 * numBlocks;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(numKVs);
        byte[] b = Bytes.toBytes("x");
        int totalSize = 0;
        for (int i = numKVs; i > 0; --i) {
            KeyValue kv = new KeyValue(b, b, b, (long)i, b);
            kvs.add(kv);
            totalSize += kv.getLength() + 1;
        }
        int blockSize = totalSize / numBlocks;
        HFileContext meta = new HFileContextBuilder().withBlockSize(blockSize).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(conf, cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        kvs.remove(kvs.size() - 1);
        for (KeyValue kv : kvs) {
            writer.append(kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        return writer;
    }

    public void testDataBlockEncodingMetaData() throws IOException {
        Path dir = new Path(new Path(testDir, "7e0102"), "familyname");
        Path path = new Path(dir, "1234567890");
        DataBlockEncoding dataBlockEncoderAlgo = DataBlockEncoding.FAST_DIFF;
        HFileDataBlockEncoderImpl dataBlockEncoder = new HFileDataBlockEncoderImpl(dataBlockEncoderAlgo);
        this.cacheConf = new CacheConfig(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).withDataBlockEncoding(dataBlockEncoderAlgo).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        writer.close();
        StoreFile storeFile = new StoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE);
        StoreFile.Reader reader = storeFile.createReader();
        Map<byte[], byte[]> fileInfo = reader.loadFileInfo();
        byte[] value = fileInfo.get(HFileDataBlockEncoder.DATA_BLOCK_ENCODING);
        TestStoreFile.assertEquals(dataBlockEncoderAlgo.getNameInBytes(), value);
    }
}

