/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hive.org.apache.log4j.Level;
import org.apache.hive.org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerMetrics {
    private static MetricsAssertHelper metricsHelper;
    private static MiniHBaseCluster cluster;
    private static HRegionServer rs;
    private static Configuration conf;
    private static HBaseTestingUtility TEST_UTIL;
    private static MetricsRegionServer metricsRegionServer;
    private static MetricsRegionServerSource serverSource;
    private static final int NUM_SCAN_NEXT = 30;
    private static int numScanNext;

    @BeforeClass
    public static void startCluster() throws Exception {
        metricsHelper = CompatibilityFactory.getInstance(MetricsAssertHelper.class);
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.getLong("hbase.splitlog.max.resubmit", 0L);
        conf.setInt("zookeeper.recovery.retry", 0);
        conf.setInt("hbase.regionserver.info.port", -1);
        TEST_UTIL.startMiniCluster(1, 1);
        cluster = TEST_UTIL.getHBaseCluster();
        cluster.waitForActiveAndReadyMaster();
        while (cluster.getLiveRegionServerThreads().size() < 1) {
            Threads.sleep(100L);
        }
        rs = cluster.getRegionServer(0);
        metricsRegionServer = rs.getRegionServerMetrics();
        serverSource = metricsRegionServer.getMetricsSource();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test(timeout=300000L)
    public void testRegionCount() throws Exception {
        String regionMetricsKey = "regionCount";
        long regions = metricsHelper.getGaugeLong(regionMetricsKey, (BaseSource)serverSource);
        TEST_UTIL.createTable(TableName.valueOf("table"), Bytes.toBytes("cf"));
        metricsHelper.assertGaugeGt(regionMetricsKey, regions, (BaseSource)serverSource);
    }

    @Test
    public void testLocalFiles() throws Exception {
        metricsHelper.assertGauge("percentFilesLocal", 0L, (BaseSource)serverSource);
        metricsHelper.assertGauge("percentFilesLocalSecondaryRegions", 0L, (BaseSource)serverSource);
    }

    @Test
    public void testRequestCount() throws Exception {
        String tableNameString = "testRequestCount";
        TableName tName = TableName.valueOf(tableNameString);
        byte[] cfName = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] initValue = Bytes.toBytes("Value");
        TEST_UTIL.createTable(tName, cfName);
        Connection connection = TEST_UTIL.getConnection();
        connection.getTable(tName).close();
        Table table = connection.getTable(tName);
        Put p = new Put(row);
        p.add(cfName, qualifier, initValue);
        table.put(p);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long requests = metricsHelper.getCounter("totalRequestCount", (BaseSource)serverSource);
        long readRequests = metricsHelper.getCounter("readRequestCount", (BaseSource)serverSource);
        long writeRequests = metricsHelper.getCounter("writeRequestCount", (BaseSource)serverSource);
        for (int i = 0; i < 30; ++i) {
            table.put(p);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 30L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        Get g = new Get(row);
        for (int i = 0; i < 10; ++i) {
            table.get(g);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 40L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 10L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        try (RegionLocator locator = connection.getRegionLocator(tName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_getNumOps", 10L, (BaseSource)agg);
                metricsHelper.assertCounter(prefix + "_mutateCount", 31L, (BaseSource)agg);
            }
        }
        ArrayList<Get> gets = new ArrayList<Get>();
        for (int i = 0; i < 10; ++i) {
            gets.add(new Get(row));
        }
        table.get(gets);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", (requests += 3L) + 50L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", ++readRequests + 20L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 30; ++i) {
            puts.add(p);
        }
        table.put(puts);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 80L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 20L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 60L, (BaseSource)serverSource);
        table.close();
    }

    @Test
    public void testMutationsWithoutWal() throws Exception {
        TableName tableName = TableName.valueOf("testMutationsWithoutWal");
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        p.setDurability(Durability.SKIP_WAL);
        t.put(p);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("mutationsWithoutWALCount", 1L, (BaseSource)serverSource);
        long minLength = row.length + cf.length + qualifier.length + val.length;
        metricsHelper.assertGaugeGt("mutationsWithoutWALSize", minLength, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testStoreCount() throws Exception {
        TableName tableName = TableName.valueOf("testStoreCount");
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long stores = metricsHelper.getGaugeLong("storeCount", (BaseSource)serverSource);
        long storeFiles = metricsHelper.getGaugeLong("storeFileCount", (BaseSource)serverSource);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("storeCount", stores + 1L, (BaseSource)serverSource);
        metricsHelper.assertGauge("storeFileCount", storeFiles + 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testCheckAndPutCount() throws Exception {
        String tableNameString = "testCheckAndPutCount";
        TableName tableName = TableName.valueOf(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] valOne = Bytes.toBytes("Value");
        byte[] valTwo = Bytes.toBytes("ValueTwo");
        byte[] valThree = Bytes.toBytes("ValueThree");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, valOne);
        t.put(p);
        Put pTwo = new Put(row);
        pTwo.add(cf, qualifier, valTwo);
        t.checkAndPut(row, cf, qualifier, valOne, pTwo);
        Put pThree = new Put(row);
        pThree.add(cf, qualifier, valThree);
        t.checkAndPut(row, cf, qualifier, valOne, pThree);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("checkMutateFailedCount", 1L, (BaseSource)serverSource);
        metricsHelper.assertCounter("checkMutatePassedCount", 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testIncrement() throws Exception {
        String tableNameString = "testIncrement";
        TableName tableName = TableName.valueOf(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes(0L);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        for (int count = 0; count < 13; ++count) {
            Increment inc = new Increment(row);
            inc.addColumn(cf, qualifier, 100L);
            t.increment(inc);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("incrementNumOps", 13L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testAppend() throws Exception {
        String tableNameString = "testAppend";
        TableName tableName = TableName.valueOf(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("One");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        for (int count = 0; count < 73; ++count) {
            Append append = new Append(row);
            append.add(cf, qualifier, Bytes.toBytes(",Test"));
            t.append(append);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("appendNumOps", 73L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testScanNext() throws IOException {
        String tableNameString = "testScanNext";
        TableName tableName = TableName.valueOf(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("One");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes("" + insertCount + "row"));
            p.add(cf, qualifier, val);
            puts.add(p);
        }
        try (HTable t = TEST_UTIL.createTable(tableName, cf);){
            t.put(puts);
            Scan s = new Scan();
            s.setBatch(1);
            s.setCaching(1);
            ResultScanner resultScanners = t.getScanner(s);
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
        }
        numScanNext += 30;
        var8_9 = null;
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_scanNextNumOps", 30L, (BaseSource)agg);
            }
            metricsHelper.assertCounterGt("ScanNext_num_ops", (long)numScanNext, (BaseSource)serverSource);
        }
        catch (Throwable x2) {
            var8_9 = x2;
            throw x2;
        }
        var8_9 = null;
        try (HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testScanNextForSmallScan() throws IOException {
        String tableNameString = "testScanNextSmall";
        TableName tableName = TableName.valueOf(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("One");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes("" + insertCount + "row"));
            p.add(cf, qualifier, val);
            puts.add(p);
        }
        try (HTable t = TEST_UTIL.createTable(tableName, cf);){
            t.put(puts);
            Scan s = new Scan();
            s.setSmall(true);
            s.setCaching(1);
            ResultScanner resultScanners = t.getScanner(s);
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
        }
        numScanNext += 30;
        var8_9 = null;
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            int cnt = 0;
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                ++cnt;
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_scanNextNumOps", 30L, (BaseSource)agg);
            }
            metricsHelper.assertCounterGt("ScanNext_num_ops", (long)numScanNext, (BaseSource)serverSource);
        }
        catch (Throwable x2) {
            var8_9 = x2;
            throw x2;
        }
        var8_9 = null;
        try (HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
    }

    static {
        Logger.getLogger("org.apache.hadoop.hbase").setLevel(Level.DEBUG);
        numScanNext = 0;
    }
}

