/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TestMetaTableAccessor;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TestRegionServerNoMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionReplicas {
    private static final Log LOG = LogFactory.getLog(TestRegionReplicas.class);
    private static final int NB_SERVERS = 1;
    private static HTable table;
    private static final byte[] row;
    private static HRegionInfo hriPrimary;
    private static HRegionInfo hriSecondary;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;

    @BeforeClass
    public static void before() throws Exception {
        HTU.getConfiguration().setInt("dfs.blocksize", 8192);
        HTU.getConfiguration().setInt("dfs.client.read.prefetch.size", 1);
        HTU.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 0x8000000);
        HTU.startMiniCluster(1);
        TableName tableName = TableName.valueOf(TestRegionReplicas.class.getSimpleName());
        table = HTU.createTable(tableName, f);
        hriPrimary = table.getRegionLocation(row, false).getRegionInfo();
        hriSecondary = new HRegionInfo(hriPrimary.getTable(), hriPrimary.getStartKey(), hriPrimary.getEndKey(), hriPrimary.isSplit(), hriPrimary.getRegionId(), 1);
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        table.close();
        HTU.shutdownMiniCluster();
    }

    @After
    public void after() throws Exception {
        ZKAssign.deleteNodeFailSilent(HTU.getZooKeeperWatcher(), hriPrimary);
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenRegionReplica() throws Exception {
        TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
        try {
            HTU.loadNumericRows(table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows(table));
        }
        finally {
            HTU.deleteNumericRows(table, f, 0, 1000);
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRegionReplicaUpdatesMetaLocation() throws Exception {
        TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
        Table meta = null;
        try {
            meta = HTU.getConnection().getTable(TableName.META_TABLE_NAME);
            TestMetaTableAccessor.assertMetaLocation(meta, hriPrimary.getRegionName(), this.getRS().getServerName(), -1L, 1, false);
        }
        finally {
            if (meta != null) {
                meta.close();
            }
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRegionReplicaGets() throws Exception {
        try {
            HTU.loadNumericRows(table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows(table));
            Region region = this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName());
            region.flush(true);
            TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
            region = this.getRS().getFromOnlineRegions(hriSecondary.getEncodedName());
            this.assertGet(region, 42, true);
            this.assertGetRpc(hriSecondary, 42, true);
        }
        finally {
            HTU.deleteNumericRows(table, HConstants.CATALOG_FAMILY, 0, 1000);
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetOnTargetRegionReplica() throws Exception {
        try {
            HTU.loadNumericRows(table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows(table));
            Region region = this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName());
            region.flush(true);
            TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
            byte[] row = Bytes.toBytes(String.valueOf(42));
            Get get = new Get(row);
            get.setConsistency(Consistency.TIMELINE);
            get.setReplicaId(1);
            Result result = table.get(get);
            Assert.assertArrayEquals((byte[])row, (byte[])result.getValue(f, null));
        }
        finally {
            HTU.deleteNumericRows(table, HConstants.CATALOG_FAMILY, 0, 1000);
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    private void assertGet(Region region, int value, boolean expect) throws IOException {
        byte[] row = Bytes.toBytes(String.valueOf(value));
        Get get = new Get(row);
        Result result = region.get(get);
        if (expect) {
            Assert.assertArrayEquals((byte[])row, (byte[])result.getValue(f, null));
        } else {
            result.isEmpty();
        }
    }

    private void assertGetRpc(HRegionInfo info, int value, boolean expect) throws IOException, ServiceException {
        byte[] row = Bytes.toBytes(String.valueOf(value));
        Get get = new Get(row);
        ClientProtos.GetRequest getReq = RequestConverter.buildGetRequest(info.getRegionName(), get);
        ClientProtos.GetResponse getResp = this.getRS().getRSRpcServices().get(null, getReq);
        Result result = ProtobufUtil.toResult(getResp.getResult());
        if (expect) {
            Assert.assertArrayEquals((byte[])row, (byte[])result.getValue(f, null));
        } else {
            result.isEmpty();
        }
    }

    private void restartRegionServer() throws Exception {
        TestRegionReplicas.afterClass();
        TestRegionReplicas.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRefreshStoreFiles() throws Exception {
        int refreshPeriod = 2000;
        HTU.getConfiguration().setInt("hbase.hstore.compactionThreshold", 100);
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 2000);
        this.restartRegionServer();
        try {
            LOG.info("Opening the secondary region " + hriSecondary.getEncodedName());
            TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
            LOG.info("Loading data to primary region");
            HTU.loadNumericRows(table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows(table));
            LOG.info("Flushing primary region");
            Region region = this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName());
            region.flush(true);
            LOG.info("Sleeping for 8000");
            Threads.sleep(8000L);
            LOG.info("Checking results from secondary region replica");
            Region secondaryRegion = this.getRS().getFromOnlineRegions(hriSecondary.getEncodedName());
            Assert.assertEquals((long)1L, (long)secondaryRegion.getStore(f).getStorefilesCount());
            this.assertGet(secondaryRegion, 42, true);
            this.assertGetRpc(hriSecondary, 42, true);
            this.assertGetRpc(hriSecondary, 1042, false);
            HTU.loadNumericRows(table, f, 1000, 1100);
            region = this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName());
            region.flush(true);
            HTU.loadNumericRows(table, f, 2000, 2100);
            region = this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName());
            region.flush(true);
            Threads.sleep(8000L);
            this.assertGetRpc(hriSecondary, 42, true);
            this.assertGetRpc(hriSecondary, 1042, true);
            this.assertGetRpc(hriSecondary, 2042, true);
            Assert.assertEquals((long)3L, (long)secondaryRegion.getStore(f).getStorefilesCount());
            HTU.compact(table.getName(), true);
            long wakeUpTime = System.currentTimeMillis() + 8000L;
            while (System.currentTimeMillis() < wakeUpTime) {
                this.assertGetRpc(hriSecondary, 42, true);
                this.assertGetRpc(hriSecondary, 1042, true);
                this.assertGetRpc(hriSecondary, 2042, true);
                Threads.sleep(10L);
            }
            Assert.assertEquals((long)1L, (long)secondaryRegion.getStore(f).getStorefilesCount());
        }
        finally {
            HTU.deleteNumericRows(table, HConstants.CATALOG_FAMILY, 0, 1000);
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFlushAndCompactionsInPrimary() throws Exception {
        long runtime = 30000L;
        int refreshPeriod = 100;
        HTU.getConfiguration().setInt("hbase.hstore.compactionThreshold", 3);
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 100);
        this.restartRegionServer();
        boolean startKey = false;
        int endKey = 1000;
        try {
            TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
            HTU.loadNumericRows(table, f, 0, 1000);
            TestRegionServerNoMaster.flushRegion(HTU, hriPrimary);
            Threads.sleep(200L);
            final AtomicBoolean running = new AtomicBoolean(true);
            final AtomicReference[] exceptions = new AtomicReference[3];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = new AtomicReference();
            }
            Runnable writer = new Runnable(){
                int key = 0;

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            byte[] data = Bytes.toBytes(String.valueOf(this.key));
                            Put put = new Put(data);
                            put.add(f, null, data);
                            table.put(put);
                            ++this.key;
                            if (this.key != 1000) continue;
                            this.key = 0;
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn(ex);
                        exceptions[0].compareAndSet(null, ex);
                    }
                }
            };
            Runnable flusherCompactor = new Runnable(){
                Random random = new Random();

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            if (this.random.nextBoolean()) {
                                TestRegionServerNoMaster.flushRegion(HTU, hriPrimary);
                                continue;
                            }
                            HTU.compact(table.getName(), this.random.nextBoolean());
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn(ex);
                        exceptions[1].compareAndSet(null, ex);
                    }
                }
            };
            Runnable reader = new Runnable(){
                Random random = new Random();

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            if (this.random.nextInt(10) == 0) {
                                try {
                                    TestRegionServerNoMaster.closeRegion(HTU, TestRegionReplicas.this.getRS(), hriSecondary);
                                }
                                catch (Exception ex) {
                                    LOG.warn("Failed closing the region " + hriSecondary + " " + StringUtils.stringifyException((Throwable)ex));
                                    exceptions[2].compareAndSet(null, ex);
                                }
                                try {
                                    TestRegionServerNoMaster.openRegion(HTU, TestRegionReplicas.this.getRS(), hriSecondary);
                                }
                                catch (Exception ex) {
                                    LOG.warn("Failed opening the region " + hriSecondary + " " + StringUtils.stringifyException((Throwable)ex));
                                    exceptions[2].compareAndSet(null, ex);
                                }
                            }
                            int key = this.random.nextInt(1000) + 0;
                            TestRegionReplicas.this.assertGetRpc(hriSecondary, key, true);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Failed getting the value in the region " + hriSecondary + " " + StringUtils.stringifyException((Throwable)ex));
                        exceptions[2].compareAndSet(null, ex);
                    }
                }
            };
            LOG.info("Starting writer and reader");
            ExecutorService executor = Executors.newFixedThreadPool(3);
            executor.submit(writer);
            executor.submit(flusherCompactor);
            executor.submit(reader);
            Threads.sleep(runtime);
            running.set(false);
            executor.shutdown();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
            for (AtomicReference exRef : exceptions) {
                Assert.assertNull(exRef.get());
            }
        }
        finally {
            HTU.deleteNumericRows(table, HConstants.CATALOG_FAMILY, 0, 1000);
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testVerifySecondaryAbilityToReadWithOnFiles() throws Exception {
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 0);
        this.restartRegionServer();
        try {
            LOG.info("Opening the secondary region " + hriSecondary.getEncodedName());
            TestRegionServerNoMaster.openRegion(HTU, this.getRS(), hriSecondary);
            LOG.info("Loading data to primary region");
            for (int i = 0; i < 3; ++i) {
                HTU.loadNumericRows(table, f, i * 1000, (i + 1) * 1000);
                Region region = this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName());
                region.flush(true);
            }
            Region primaryRegion = this.getRS().getFromOnlineRegions(hriPrimary.getEncodedName());
            Assert.assertEquals((long)3L, (long)primaryRegion.getStore(f).getStorefilesCount());
            Region secondaryRegion = this.getRS().getFromOnlineRegions(hriSecondary.getEncodedName());
            secondaryRegion.getStore(f).refreshStoreFiles();
            Assert.assertEquals((long)3L, (long)secondaryRegion.getStore(f).getStorefilesCount());
            LOG.info("Force Major compaction on primary region " + hriPrimary);
            primaryRegion.compact(true);
            Assert.assertEquals((long)1L, (long)primaryRegion.getStore(f).getStorefilesCount());
            int keys = 0;
            int sum = 0;
            for (StoreFile sf : secondaryRegion.getStore(f).getStorefiles()) {
                LOG.debug(this.getRS().getFileSystem().exists(sf.getPath()));
                Assert.assertFalse((boolean)this.getRS().getFileSystem().exists(sf.getPath()));
                HFileScanner scanner = sf.getReader().getScanner(false, false);
                scanner.seekTo();
                do {
                    ++keys;
                    Cell cell = scanner.getKeyValue();
                    sum += Integer.parseInt(Bytes.toString(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
                } while (scanner.next());
            }
            Assert.assertEquals((long)3000L, (long)keys);
            Assert.assertEquals((long)0x44A444L, (long)sum);
        }
        finally {
            HTU.deleteNumericRows(table, HConstants.CATALOG_FAMILY, 0, 1000);
            TestRegionServerNoMaster.closeRegion(HTU, this.getRS(), hriSecondary);
        }
    }

    static {
        row = "TestRegionReplicas".getBytes();
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
    }
}

