/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.replication.regionserver.TestRegionReplicaReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hive.org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class})
public class TestRegionReplicaFailover {
    private static final Log LOG = LogFactory.getLog(TestRegionReplicaReplicationEndpoint.class);
    private static final HBaseTestingUtility HTU;
    private static final int NB_SERVERS = 3;
    protected final byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
    protected final byte[] fam = HBaseTestingUtility.fam1;
    protected final byte[] qual1 = Bytes.toBytes("qual1");
    protected final byte[] value1 = Bytes.toBytes("value1");
    protected final byte[] row = Bytes.toBytes("rowA");
    protected final byte[] row2 = Bytes.toBytes("rowB");
    @Rule
    public TestName name = new TestName();
    private HTableDescriptor htd;
    @Parameterized.Parameter(value=0)
    public boolean distributedLogReplay;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        Boolean[][] params = new Boolean[][]{{true}, {false}};
        return Arrays.asList(params);
    }

    @Before
    public void before() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setBoolean("hbase.region.replica.wait.for.primary.flush", true);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setBoolean("hbase.master.distributed.log.replay", this.distributedLogReplay);
        conf.setInt("hbase.regionserver.metahandler.count", 60);
        HTU.startMiniCluster(3);
        this.htd = HTU.createTableDescriptor(this.name.getMethodName().substring(0, this.name.getMethodName().length() - 3));
        this.htd.setRegionReplication(3);
        HTU.getHBaseAdmin().createTable(this.htd);
    }

    @After
    public void after() throws Exception {
        HTU.deleteTableIfAny(this.htd.getTableName());
        HTU.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testSecondaryRegionWithEmptyRegion() throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(HTU.getConfiguration());
             Table table = connection.getTable(this.htd.getTableName());){
            Get get = new Get(this.row);
            get.setConsistency(Consistency.TIMELINE);
            get.setReplicaId(1);
            table.get(get);
        }
    }

    @Test(timeout=60000L)
    public void testSecondaryRegionWithNonEmptyRegion() throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(HTU.getConfiguration());
             Table table = connection.getTable(this.htd.getTableName());){
            HTU.loadNumericRows(table, this.fam, 0, 1000);
            HTU.getHBaseAdmin().disableTable(this.htd.getTableName());
            HTU.getHBaseAdmin().enableTable(this.htd.getTableName());
            HTU.verifyNumericRows(table, this.fam, 0, 1000, 1);
        }
    }

    @Test(timeout=120000L)
    public void testPrimaryRegionKill() throws Exception {
        try (Connection connection = ConnectionFactory.createConnection(HTU.getConfiguration());
             Table table = connection.getTable(this.htd.getTableName());){
            HTU.loadNumericRows(table, this.fam, 0, 1000);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 1, 30000L);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 2, 30000L);
            boolean aborted = false;
            for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                for (Region r : rs.getRegionServer().getOnlineRegions(this.htd.getTableName())) {
                    if (r.getRegionInfo().getReplicaId() != 0) continue;
                    LOG.info("Aborting region server hosting primary region replica");
                    rs.getRegionServer().abort("for test");
                    aborted = true;
                }
            }
            Assert.assertTrue((boolean)aborted);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 0, 30000L);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 1, 30000L);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 2, 30000L);
        }
        HTU.getMiniHBaseCluster().startRegionServer();
    }

    private void verifyNumericRowsWithTimeout(final Table table, final byte[] f, final int startRow, final int endRow, final int replicaId, long timeout) throws Exception {
        try {
            HTU.waitFor(timeout, new Waiter.Predicate<Exception>(){

                @Override
                public boolean evaluate() throws Exception {
                    try {
                        HTU.verifyNumericRows(table, f, startRow, endRow, replicaId);
                        return true;
                    }
                    catch (AssertionError ae) {
                        return false;
                    }
                }
            });
        }
        catch (Throwable t) {
            HTU.verifyNumericRows(table, f, startRow, endRow, replicaId);
        }
    }

    @Test(timeout=120000L)
    public void testSecondaryRegionKill() throws Exception {
        try (Connection connection = ConnectionFactory.createConnection(HTU.getConfiguration());
             Table table = connection.getTable(this.htd.getTableName());){
            HTU.loadNumericRows(table, this.fam, 0, 1000);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 1, 30000L);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, 1000, 2, 30000L);
            boolean aborted = false;
            for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                for (Region r : rs.getRegionServer().getOnlineRegions(this.htd.getTableName())) {
                    if (r.getRegionInfo().getReplicaId() != 1) continue;
                    LOG.info("Aborting region server hosting secondary region replica");
                    rs.getRegionServer().abort("for test");
                    aborted = true;
                }
            }
            Assert.assertTrue((boolean)aborted);
            Threads.sleep(5000L);
            HTU.verifyNumericRows(table, this.fam, 0, 1000, 1);
            HTU.verifyNumericRows(table, this.fam, 0, 1000, 2);
        }
        HTU.getMiniHBaseCluster().startRegionServer();
    }

    @Test(timeout=120000L)
    public void testSecondaryRegionKillWhilePrimaryIsAcceptingWrites() throws Exception {
        try (Connection connection = ConnectionFactory.createConnection(HTU.getConfiguration());
             final Table table = connection.getTable(this.htd.getTableName());
             Admin admin = connection.getAdmin();){
            HTU.loadNumericRows(table, this.fam, 0, 1000);
            admin.flush(table.getName());
            HTU.loadNumericRows(table, this.fam, 1000, 2000);
            final AtomicReference<Object> ex = new AtomicReference<Object>(null);
            final AtomicBoolean done = new AtomicBoolean(false);
            final AtomicInteger key = new AtomicInteger(2000);
            Thread loader = new Thread(){

                @Override
                public void run() {
                    while (!done.get()) {
                        try {
                            HTU.loadNumericRows(table, TestRegionReplicaFailover.this.fam, key.get(), key.get() + 1000);
                            key.addAndGet(1000);
                        }
                        catch (Throwable e) {
                            ex.compareAndSet(null, e);
                        }
                    }
                }
            };
            loader.start();
            Thread aborter = new Thread(){

                @Override
                public void run() {
                    try {
                        boolean aborted = false;
                        for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                            for (Region r : rs.getRegionServer().getOnlineRegions(TestRegionReplicaFailover.this.htd.getTableName())) {
                                if (r.getRegionInfo().getReplicaId() != 1) continue;
                                LOG.info("Aborting region server hosting secondary region replica");
                                rs.getRegionServer().abort("for test");
                                aborted = true;
                            }
                        }
                        Assert.assertTrue((boolean)aborted);
                    }
                    catch (Throwable e) {
                        ex.compareAndSet(null, e);
                    }
                }
            };
            aborter.start();
            aborter.join();
            done.set(true);
            loader.join();
            Assert.assertNull(ex.get());
            Assert.assertTrue((key.get() > 1000 ? 1 : 0) != 0);
            LOG.info("Loaded up to key :" + key.get());
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, key.get(), 0, 30000L);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, key.get(), 1, 30000L);
            this.verifyNumericRowsWithTimeout(table, this.fam, 0, key.get(), 2, 30000L);
        }
        HTU.getMiniHBaseCluster().startRegionServer();
    }

    @Test(timeout=120000L)
    public void testLotsOfRegionReplicas() throws IOException {
        int numRegions = 60;
        int regionReplication = 10;
        String tableName = this.htd.getTableName().getNameAsString() + "2";
        this.htd = HTU.createTableDescriptor(tableName);
        this.htd.setRegionReplication(regionReplication);
        byte[] startKey = Bytes.toBytes("aaa");
        byte[] endKey = Bytes.toBytes("zzz");
        byte[][] splits = HTU.getRegionSplitStartKeys(startKey, endKey, numRegions);
        HTU.getHBaseAdmin().createTable(this.htd, startKey, endKey, numRegions);
        try (Connection connection = ConnectionFactory.createConnection(HTU.getConfiguration());
             Table table = connection.getTable(this.htd.getTableName());){
            for (int i = 1; i < splits.length; ++i) {
                for (int j = 0; j < regionReplication; ++j) {
                    Get get = new Get(splits[i]);
                    get.setConsistency(Consistency.TIMELINE);
                    get.setReplicaId(j);
                    table.get(get);
                }
            }
        }
        HTU.deleteTableIfAny(TableName.valueOf(tableName));
    }

    static {
        ((Log4JLogger)RpcRetryingCaller.LOG).getLogger().setLevel(Level.ALL);
        HTU = new HBaseTestingUtility();
    }
}

