/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.base.Joiner;
import org.apache.hive.org.apache.commons.lang.math.RandomUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRegionMergeTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestRegionMergeTransactionOnCluster.class);
    private static final int NB_SERVERS = 3;
    private static final byte[] FAMILYNAME = Bytes.toBytes("fam");
    private static final byte[] QUALIFIER = Bytes.toBytes("q");
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static final int INITIAL_REGION_NUM = 10;
    private static final int ROWSIZE = 200;
    private static byte[][] ROWS = TestRegionMergeTransactionOnCluster.makeN(ROW, 200);
    private static int waitTime = 60000;
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static HMaster master;
    private static Admin admin;

    static void setupOnce() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        master = cluster.getMaster();
        master.balanceSwitch(false);
        admin = TEST_UTIL.getHBaseAdmin();
    }

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        TestRegionMergeTransactionOnCluster.setupOnce();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWholesomeMerge() throws Exception {
        LOG.info("Starting testWholesomeMerge");
        TableName tableName = TableName.valueOf("testWholesomeMerge");
        Table table = this.createTableAndLoadData(master, tableName);
        this.mergeRegionsAndVerifyRegionNum(master, tableName, 0, 1, 9);
        PairOfSameType<HRegionInfo> mergedRegions = this.mergeRegionsAndVerifyRegionNum(master, tableName, 1, 2, 8);
        this.verifyRowCount(table, 200);
        HRegionInfo hri = RandomUtils.nextBoolean() ? mergedRegions.getFirst() : mergedRegions.getSecond();
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        AssignmentManager am = cluster.getMaster().getAssignmentManager();
        RegionStates regionStates = am.getRegionStates();
        long start = EnvironmentEdgeManager.currentTime();
        while (!regionStates.isRegionInState(hri, RegionState.State.MERGED)) {
            Assert.assertFalse((String)"Timed out in waiting one merged region to be in state MERGED", (EnvironmentEdgeManager.currentTime() - start > 60000L ? 1 : 0) != 0);
            Thread.sleep(500L);
        }
        am.assign(hri, true, true);
        Assert.assertFalse((String)"Merged region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
        Assert.assertTrue((boolean)regionStates.isRegionInState(hri, RegionState.State.MERGED));
        am.unassign(hri, true, null);
        Assert.assertFalse((String)"Merged region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
        Assert.assertTrue((boolean)regionStates.isRegionInState(hri, RegionState.State.MERGED));
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanMergeReference() throws Exception {
        LOG.info("Starting testCleanMergeReference");
        admin.enableCatalogJanitor(false);
        try {
            TableName tableName = TableName.valueOf("testCleanMergeReference");
            Table table = this.createTableAndLoadData(master, tableName);
            this.mergeRegionsAndVerifyRegionNum(master, tableName, 0, 1, 9);
            this.verifyRowCount(table, 200);
            table.close();
            List<Pair<HRegionInfo, ServerName>> tableRegions = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tableName);
            HRegionInfo mergedRegionInfo = tableRegions.get(0).getFirst();
            HTableDescriptor tableDescritor = master.getTableDescriptors().get(tableName);
            Result mergedRegionResult = MetaTableAccessor.getRegionResult(master.getConnection(), mergedRegionInfo.getRegionName());
            Assert.assertTrue((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null ? 1 : 0) != 0);
            Assert.assertTrue((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER) != null ? 1 : 0) != 0);
            HRegionInfo regionA = HRegionInfo.getHRegionInfo(mergedRegionResult, HConstants.MERGEA_QUALIFIER);
            HRegionInfo regionB = HRegionInfo.getHRegionInfo(mergedRegionResult, HConstants.MERGEB_QUALIFIER);
            FileSystem fs = master.getMasterFileSystem().getFileSystem();
            Path rootDir = master.getMasterFileSystem().getRootDir();
            Path tabledir = FSUtils.getTableDir(rootDir, mergedRegionInfo.getTable());
            Path regionAdir = new Path(tabledir, regionA.getEncodedName());
            Path regionBdir = new Path(tabledir, regionB.getEncodedName());
            Assert.assertTrue((boolean)fs.exists(regionAdir));
            Assert.assertTrue((boolean)fs.exists(regionBdir));
            admin.compactRegion(mergedRegionInfo.getRegionName());
            long timeout = System.currentTimeMillis() + (long)waitTime;
            HRegionFileSystem hrfs = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, tabledir, mergedRegionInfo);
            while (System.currentTimeMillis() < timeout && hrfs.hasReferences(tableDescritor)) {
                Thread.sleep(50L);
            }
            Assert.assertFalse((boolean)hrfs.hasReferences(tableDescritor));
            int cleaned = admin.runCatalogScan();
            Assert.assertTrue((cleaned > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)fs.exists(regionAdir));
            Assert.assertFalse((boolean)fs.exists(regionBdir));
            mergedRegionResult = MetaTableAccessor.getRegionResult(master.getConnection(), mergedRegionInfo.getRegionName());
            Assert.assertFalse((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null ? 1 : 0) != 0);
            Assert.assertFalse((mergedRegionResult.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER) != null ? 1 : 0) != 0);
        }
        finally {
            admin.enableCatalogJanitor(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerge() throws Exception {
        LOG.info("Starting testMerge");
        TableName tableName = TableName.valueOf("testMerge");
        try {
            Table table = this.createTableAndLoadData(master, tableName);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            List<HRegionInfo> regions = regionStates.getRegionsOfTable(tableName);
            HRegionInfo a = regions.get(0);
            HRegionInfo b = regions.get(1);
            regionStates.regionOffline(a);
            try {
                admin.mergeRegions(a.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), false);
                Assert.fail((String)"Offline regions should not be able to merge");
            }
            catch (IOException ie) {
                System.out.println(ie);
                Assert.assertTrue((String)"Exception should mention regions not online", (StringUtils.stringifyException((Throwable)ie).contains("regions not online") && ie instanceof MergeRegionException ? 1 : 0) != 0);
            }
            try {
                admin.mergeRegions(b.getEncodedNameAsBytes(), b.getEncodedNameAsBytes(), true);
                Assert.fail((String)"A region should not be able to merge with itself, even forcifully");
            }
            catch (IOException ie) {
                Assert.assertTrue((String)"Exception should mention regions not online", (StringUtils.stringifyException((Throwable)ie).contains("region to itself") && ie instanceof MergeRegionException ? 1 : 0) != 0);
            }
            try {
                admin.mergeRegions(Bytes.toBytes("-f1"), Bytes.toBytes("-f2"), true);
                Assert.fail((String)"Unknown region could not be merged");
            }
            catch (IOException ie) {
                Assert.assertTrue((String)"UnknownRegionException should be thrown", (boolean)(ie instanceof UnknownRegionException));
            }
            table.close();
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testMergeWithReplicas() throws Exception {
        TableName tableName = TableName.valueOf("testMergeWithReplicas");
        this.createTableAndLoadData(master, tableName, 5, 2);
        List<Pair<HRegionInfo, ServerName>> initialRegionToServers = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tableName);
        PairOfSameType<HRegionInfo> mergedRegions = this.mergeRegionsAndVerifyRegionNum(master, tableName, 0, 2, 8);
        List<Pair<HRegionInfo, ServerName>> currentRegionToServers = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tableName);
        ArrayList<HRegionInfo> initialRegions = new ArrayList<HRegionInfo>();
        for (Pair<HRegionInfo, ServerName> p : initialRegionToServers) {
            initialRegions.add(p.getFirst());
        }
        ArrayList<HRegionInfo> currentRegions = new ArrayList<HRegionInfo>();
        for (Pair<HRegionInfo, ServerName> p : currentRegionToServers) {
            currentRegions.add(p.getFirst());
        }
        Assert.assertTrue((boolean)initialRegions.contains(mergedRegions.getFirst()));
        Assert.assertTrue((boolean)initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica(mergedRegions.getFirst(), 1)));
        Assert.assertTrue((boolean)initialRegions.contains(mergedRegions.getSecond()));
        Assert.assertTrue((boolean)initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica(mergedRegions.getSecond(), 1)));
        Assert.assertTrue((!initialRegions.contains(currentRegions.get(0)) ? 1 : 0) != 0);
        Assert.assertTrue((!initialRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)currentRegions.get(0), 1)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)currentRegions.get(0), 1)));
        Assert.assertTrue((!currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica(mergedRegions.getFirst(), 1)) ? 1 : 0) != 0);
        Assert.assertTrue((!currentRegions.contains(RegionReplicaUtil.getRegionInfoForReplica(mergedRegions.getSecond(), 1)) ? 1 : 0) != 0);
    }

    private PairOfSameType<HRegionInfo> mergeRegionsAndVerifyRegionNum(HMaster master, TableName tablename, int regionAnum, int regionBnum, int expectedRegionNum) throws Exception {
        PairOfSameType<HRegionInfo> mergedRegions = this.requestMergeRegion(master, tablename, regionAnum, regionBnum);
        this.waitAndVerifyRegionNum(master, tablename, expectedRegionNum);
        return mergedRegions;
    }

    private PairOfSameType<HRegionInfo> requestMergeRegion(HMaster master, TableName tablename, int regionAnum, int regionBnum) throws Exception {
        List<Pair<HRegionInfo, ServerName>> tableRegions = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tablename);
        HRegionInfo regionA = tableRegions.get(regionAnum).getFirst();
        HRegionInfo regionB = tableRegions.get(regionBnum).getFirst();
        TEST_UTIL.getHBaseAdmin().mergeRegions(regionA.getEncodedNameAsBytes(), regionB.getEncodedNameAsBytes(), false);
        return new PairOfSameType<HRegionInfo>(regionA, regionB);
    }

    private void waitAndVerifyRegionNum(HMaster master, TableName tablename, int expectedRegionNum) throws Exception {
        List<Pair<HRegionInfo, ServerName>> tableRegionsInMeta;
        long timeout = System.currentTimeMillis() + (long)waitTime;
        while (System.currentTimeMillis() < timeout) {
            tableRegionsInMeta = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tablename);
            List<HRegionInfo> tableRegionsInMaster = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tablename);
            if (tableRegionsInMeta.size() == expectedRegionNum && tableRegionsInMaster.size() == expectedRegionNum) break;
            Thread.sleep(250L);
        }
        tableRegionsInMeta = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tablename);
        LOG.info("Regions after merge:" + Joiner.on(',').join(tableRegionsInMeta));
        Assert.assertEquals((long)expectedRegionNum, (long)tableRegionsInMeta.size());
    }

    private Table createTableAndLoadData(HMaster master, TableName tablename) throws Exception {
        return this.createTableAndLoadData(master, tablename, 10, 1);
    }

    private Table createTableAndLoadData(HMaster master, TableName tablename, int numRegions, int replication) throws Exception {
        List<Pair<HRegionInfo, ServerName>> tableRegions;
        Assert.assertTrue((String)("ROWSIZE must > numregions:" + numRegions), (200 > numRegions ? 1 : 0) != 0);
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 0; i < splitRows.length; ++i) {
            splitRows[i] = ROWS[(i + 1) * 200 / numRegions];
        }
        HTable table = TEST_UTIL.createTable(tablename, FAMILYNAME, (byte[][])splitRows);
        if (replication > 1) {
            HBaseTestingUtility.setReplicas(admin, tablename, replication);
        }
        this.loadData(table);
        this.verifyRowCount(table, 200);
        long timeout = System.currentTimeMillis() + (long)waitTime;
        while (System.currentTimeMillis() < timeout && (tableRegions = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tablename)).size() != numRegions * replication) {
            Thread.sleep(250L);
        }
        tableRegions = MetaTableAccessor.getTableRegionsAndLocations(master.getZooKeeper(), master.getConnection(), tablename);
        LOG.info("Regions after load: " + Joiner.on(',').join(tableRegions));
        Assert.assertEquals((long)(numRegions * replication), (long)tableRegions.size());
        return table;
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add(base, Bytes.toBytes(String.format("%04d", i)));
        }
        return ret;
    }

    private void loadData(Table table) throws IOException {
        for (int i = 0; i < 200; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILYNAME, QUALIFIER, Bytes.toBytes(i));
            table.put(put);
        }
    }

    private void verifyRowCount(Table table, int expectedRegionNum) throws IOException {
        ResultScanner scanner = table.getScanner(new Scan());
        int rowCount = 0;
        while (scanner.next() != null) {
            ++rowCount;
        }
        Assert.assertEquals((long)expectedRegionNum, (long)rowCount);
        scanner.close();
    }
}

