/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRSKilledWhenInitializing {
    private static boolean masterActive = false;
    private static AtomicBoolean firstRS = new AtomicBoolean(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRSTermnationAfterRegisteringToMasterBeforeCreatingEphemeralNod() throws Exception {
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        firstRS.set(true);
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniDFSCluster(3);
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.createRootDir();
        LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 2, HMaster.class, MockedRegionServer.class);
        JVMClusterUtil.MasterThread master = cluster.getMasters().get(0);
        master.start();
        try {
            long startTime = System.currentTimeMillis();
            while (!master.getMaster().isActiveMaster()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= startTime + 30000L) continue;
                throw new RuntimeException("Master not active after 30 seconds");
            }
            masterActive = true;
            cluster.getRegionServers().get(0).start();
            cluster.getRegionServers().get(1).start();
            Thread.sleep(10000L);
            List<ServerName> onlineServersList = master.getMaster().getServerManager().getOnlineServersList();
            while (onlineServersList.size() > 1) {
                Thread.sleep(100L);
                onlineServersList = master.getMaster().getServerManager().getOnlineServersList();
            }
            Assert.assertEquals((long)onlineServersList.size(), (long)1L);
            cluster.shutdown();
        }
        finally {
            masterActive = false;
            firstRS.set(true);
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    public static class MockedRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MockedRegionServer(Configuration conf, CoordinatedStateManager cp) throws IOException, InterruptedException {
            super(conf, cp);
        }

        @Override
        protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
            if (firstRS.getAndSet(false)) {
                for (HBaseProtos.NameStringPair e : c.getMapEntriesList()) {
                    String key = e.getName();
                    if (!key.equals("hbase.regionserver.hostname.seen.by.master")) continue;
                    String hostnameFromMasterPOV = e.getValue();
                    Assert.assertEquals((Object)super.getRpcServer().getListenerAddress().getHostName(), (Object)hostnameFromMasterPOV);
                }
                while (!masterActive) {
                    Threads.sleep(100L);
                }
                super.kill();
            } else {
                super.handleReportForDutyResponse(c);
            }
        }
    }
}

