/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.ResizableBlockCache;
import org.apache.hadoop.hbase.regionserver.FlushRequestListener;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.HeapMemoryTuner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHeapMemoryManager {
    private long maxHeapSize = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();

    @Test
    public void testAutoTunerShouldBeOffWhenMaxMinRangesForMemstoreIsNotGiven() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hfile.block.cache.size.max.range", 0.75f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        HeapMemoryManager manager = new HeapMemoryManager(new BlockCacheStub(0L), new MemstoreFlusherStub(0L), new RegionServerStub(conf));
        Assert.assertFalse((boolean)manager.isTunerOn());
    }

    @Test
    public void testAutoTunerShouldBeOffWhenMaxMinRangesForBlockCacheIsNotGiven() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.05f);
        HeapMemoryManager manager = new HeapMemoryManager(new BlockCacheStub(0L), new MemstoreFlusherStub(0L), new RegionServerStub(conf));
        Assert.assertFalse((boolean)manager.isTunerOn());
    }

    @Test
    public void testWhenMemstoreAndBlockCacheMaxMinChecksFails() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub(0L);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub(0L);
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.06f);
        try {
            new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
            Assert.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.2f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        try {
            new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
            Assert.fail();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testWhenClusterIsWriteHeavy() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        memStoreFlusher.flushType = FlushType.ABOVE_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false);
        memStoreFlusher.requestFlush(null, false);
        memStoreFlusher.requestFlush(null, false);
        memStoreFlusher.flushType = FlushType.ABOVE_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false);
        Thread.sleep(1500L);
        this.assertHeapSpaceDelta(0.02f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-0.02f, oldBlockCacheSize, blockCache.maxSize);
        oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        oldBlockCacheSize = blockCache.maxSize;
        memStoreFlusher.flushType = FlushType.ABOVE_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false);
        memStoreFlusher.requestFlush(null, false);
        Thread.sleep(1500L);
        this.assertHeapSpaceDelta(0.02f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-0.02f, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testWhenClusterIsReadHeavy() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        Thread.sleep(1500L);
        this.assertHeapSpaceDelta(-0.02f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(0.02f, oldBlockCacheSize, blockCache.maxSize);
        oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        oldBlockCacheSize = blockCache.maxSize;
        blockCache.evictBlock(null);
        Thread.sleep(1500L);
        this.assertHeapSpaceDelta(-0.02f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(0.02f, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testPluggingInHeapMemoryTuner() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.78f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.05f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.75f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.02f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.78f;
        CustomHeapMemoryTuner.blockCacheSize = 0.02f;
        Thread.sleep(1500L);
        this.assertHeapSpace(0.78f, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.02f, blockCache.maxSize);
        CustomHeapMemoryTuner.blockCacheSize = 0.75f;
        CustomHeapMemoryTuner.memstoreSize = 0.05f;
        Thread.sleep(1500L);
        this.assertHeapSpace(0.75f, blockCache.maxSize);
        this.assertHeapSpace(0.05f, memStoreFlusher.memstoreSize);
    }

    @Test
    public void testWhenSizeGivenByHeapTunerGoesOutsideRange() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.1f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.78f;
        CustomHeapMemoryTuner.blockCacheSize = 0.02f;
        Thread.sleep(1500L);
        this.assertHeapSpace(0.7f, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.1f, blockCache.maxSize);
    }

    @Test
    public void testWhenCombinedHeapSizesFromTunerGoesOutSideMaxLimit() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.1f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
        long oldMemstoreSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.7f;
        CustomHeapMemoryTuner.blockCacheSize = 0.3f;
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
    }

    @Test
    public void testWhenL2BlockCacheIsOnHeap() throws Exception {
        HeapMemoryManager heapMemoryManager = null;
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.3));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.1f);
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.4f);
        conf.setFloat("hfile.block.cache.size", 0.3f);
        conf.setFloat("hbase.bucketcache.size", 0.1f);
        conf.set("hbase.bucketcache.ioengine", "heap");
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        try {
            heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
            Assert.fail((String)"Should have failed as the collective heap memory need is above 80%");
        }
        catch (Exception e) {
            // empty catch block
        }
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.6f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.6f);
        heapMemoryManager = new HeapMemoryManager(blockCache, memStoreFlusher, new RegionServerStub(conf));
        long oldMemstoreSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.4f;
        CustomHeapMemoryTuner.blockCacheSize = 0.4f;
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
        CustomHeapMemoryTuner.memstoreSize = 0.1f;
        CustomHeapMemoryTuner.blockCacheSize = 0.5f;
        Thread.sleep(1500L);
        this.assertHeapSpace(0.1f, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.5f, blockCache.maxSize);
    }

    private void assertHeapSpace(float expectedHeapPercentage, long currentHeapSpace) {
        long expected = (long)((float)this.maxHeapSize * expectedHeapPercentage);
        Assert.assertEquals((long)expected, (long)currentHeapSpace);
    }

    private void assertHeapSpaceDelta(float expectedDeltaPercent, long oldHeapSpace, long newHeapSpace) {
        long expctedMinDelta = (long)((float)this.maxHeapSize * expectedDeltaPercent);
        if (expectedDeltaPercent > 0.0f) {
            Assert.assertTrue((expctedMinDelta <= newHeapSpace - oldHeapSpace ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((expctedMinDelta <= oldHeapSpace - newHeapSpace ? 1 : 0) != 0);
        }
    }

    static class CustomHeapMemoryTuner
    implements HeapMemoryTuner {
        static float blockCacheSize = 0.4f;
        static float memstoreSize = 0.4f;

        CustomHeapMemoryTuner() {
        }

        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration arg0) {
        }

        @Override
        public HeapMemoryManager.TunerResult tune(HeapMemoryManager.TunerContext context) {
            HeapMemoryManager.TunerResult result = new HeapMemoryManager.TunerResult(true);
            result.setBlockCacheSize(blockCacheSize);
            result.setMemstoreSize(memstoreSize);
            return result;
        }
    }

    private static class RegionServerStub
    implements Server {
        private Configuration conf;
        private boolean stopped = false;

        public RegionServerStub(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
            this.stopped = true;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf("server1", 4000, 12345L);
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }

    private static class MemstoreFlusherStub
    implements FlushRequester {
        long memstoreSize;
        FlushRequestListener listener;
        FlushType flushType = FlushType.NORMAL;

        public MemstoreFlusherStub(long memstoreSize) {
            this.memstoreSize = memstoreSize;
        }

        @Override
        public void requestFlush(Region region, boolean forceFlushAllStores) {
            this.listener.flushRequested(this.flushType, region);
        }

        @Override
        public void requestDelayedFlush(Region region, long delay, boolean forceFlushAllStores) {
        }

        @Override
        public void registerFlushRequestListener(FlushRequestListener listener) {
            this.listener = listener;
        }

        @Override
        public boolean unregisterFlushRequestListener(FlushRequestListener listener) {
            return false;
        }

        @Override
        public void setGlobalMemstoreLimit(long globalMemStoreSize) {
            this.memstoreSize = globalMemStoreSize;
        }
    }

    private static class BlockCacheStub
    implements ResizableBlockCache {
        CacheStats stats = new CacheStats("test");
        long maxSize = 0L;

        public BlockCacheStub(long size) {
            this.maxSize = size;
        }

        @Override
        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory, boolean cacheDataInL1) {
        }

        @Override
        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        }

        @Override
        public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
            return null;
        }

        @Override
        public boolean evictBlock(BlockCacheKey cacheKey) {
            this.stats.evicted(0L);
            return false;
        }

        @Override
        public int evictBlocksByHfileName(String hfileName) {
            this.stats.evicted(0L);
            return 0;
        }

        @Override
        public CacheStats getStats() {
            return this.stats;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public long getFreeSize() {
            return 0L;
        }

        @Override
        public long getCurrentSize() {
            return 0L;
        }

        @Override
        public long getBlockCount() {
            return 0L;
        }

        @Override
        public void setMaxSize(long size) {
            this.maxSize = size;
        }

        @Override
        public Iterator<CachedBlock> iterator() {
            return null;
        }

        @Override
        public BlockCache[] getBlockCaches() {
            return null;
        }
    }
}

