/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StatefulStoreMockMaker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.NoLimitCompactionThroughputController;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestCompaction {
    @Rule
    public TestName name = new TestName();
    static final Log LOG = LogFactory.getLog(TestCompaction.class.getName());
    private static final HBaseTestingUtility UTIL = HBaseTestingUtility.createLocalHTU();
    protected Configuration conf = UTIL.getConfiguration();
    private HRegion r = null;
    private HTableDescriptor htd = null;
    private static final byte[] COLUMN_FAMILY = HBaseTestingUtility.fam1;
    private final byte[] STARTROW = Bytes.toBytes(HBaseTestingUtility.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    private int compactionThreshold;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private static final long MAX_FILES_TO_COMPACT = 10L;

    public TestCompaction() {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.conf.set("hbase.regionserver.throughput.controller", NoLimitCompactionThroughputController.class.getName());
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n2 = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n2] = (byte)(this.thirdRowBytes[n2] + 2);
    }

    @Before
    public void setUp() throws Exception {
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName());
        this.r = UTIL.createLocalHRegion(this.htd, null, null);
    }

    @After
    public void tearDown() throws Exception {
        WAL wal = this.r.getWAL();
        this.r.close();
        wal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptCompaction() throws Exception {
        Assert.assertEquals((long)0L, (long)this.count());
        int origWI = HStore.closeCheckInterval;
        HStore.closeCheckInterval = 10000;
        try {
            int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
            byte[] pad = new byte[1000];
            for (int i = 0; i < this.compactionThreshold; ++i) {
                HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
                Put p = new Put(Bytes.add(this.STARTROW, Bytes.toBytes(i)));
                p.setDurability(Durability.SKIP_WAL);
                for (int j = 0; j < jmax; ++j) {
                    p.add(COLUMN_FAMILY, Bytes.toBytes(j), pad);
                }
                HBaseTestCase.addContent(loader, Bytes.toString(COLUMN_FAMILY));
                loader.put(p);
                loader.flushcache();
            }
            HRegion spyR = (HRegion)Mockito.spy((Object)this.r);
            ((HRegion)Mockito.doAnswer((Answer)new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ((TestCompaction)TestCompaction.this).r.writestate.writesEnabled = false;
                    return invocation.callRealMethod();
                }
            }).when((Object)spyR)).doRegionCompactionPrep();
            spyR.compactStores();
            Store s = this.r.stores.get(COLUMN_FAMILY);
            Assert.assertEquals((long)this.compactionThreshold, (long)s.getStorefilesCount());
            Assert.assertTrue((s.getStorefilesSize() > 15000L ? 1 : 0) != 0);
            FileStatus[] ls = this.r.getFilesystem().listStatus(this.r.getRegionFileSystem().getTempDir());
            Assert.assertEquals((long)0L, (long)ls.length);
            this.r.writestate.writesEnabled = true;
            HStore.closeCheckInterval = origWI;
        }
        catch (Throwable throwable) {
            this.r.writestate.writesEnabled = true;
            HStore.closeCheckInterval = origWI;
            for (int i = 0; i < this.compactionThreshold; ++i) {
                Delete delete = new Delete(Bytes.add(this.STARTROW, Bytes.toBytes(i)));
                byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
                delete.deleteFamily(famAndQf[0]);
                this.r.delete(delete);
            }
            this.r.flush(true);
            int ttl = 1000;
            for (Store hstore : this.r.stores.values()) {
                HStore store = (HStore)hstore;
                ScanInfo old = store.getScanInfo();
                ScanInfo si = new ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
                store.setScanInfo(si);
            }
            Thread.sleep(1000L);
            this.r.compact(true);
            Assert.assertEquals((long)0L, (long)this.count());
            throw throwable;
        }
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Delete delete = new Delete(Bytes.add(this.STARTROW, Bytes.toBytes(i)));
            byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
            delete.deleteFamily(famAndQf[0]);
            this.r.delete(delete);
        }
        this.r.flush(true);
        int ttl = 1000;
        for (Store hstore : this.r.stores.values()) {
            HStore store = (HStore)hstore;
            ScanInfo old = store.getScanInfo();
            ScanInfo si = new ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
            store.setScanInfo(si);
        }
        Thread.sleep(1000L);
        this.r.compact(true);
        Assert.assertEquals((long)0L, (long)this.count());
    }

    private int count() throws IOException {
        int count = 0;
        for (StoreFile f : this.r.stores.get(COLUMN_FAMILY_TEXT).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        this.createStoreFile(region, Bytes.toString(COLUMN_FAMILY));
    }

    private void createStoreFile(HRegion region, String family) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        HBaseTestCase.addContent(loader, family);
        loader.flushcache();
    }

    @Test
    public void testCompactionWithCorruptResult() throws Exception {
        int nfiles = 10;
        for (int i = 0; i < nfiles; ++i) {
            this.createStoreFile(this.r);
        }
        HStore store = (HStore)this.r.getStore(COLUMN_FAMILY);
        Collection<StoreFile> storeFiles = store.getStorefiles();
        DefaultCompactor tool = (DefaultCompactor)store.storeEngine.getCompactor();
        tool.compactForTesting(storeFiles, false);
        FileSystem fs = store.getFileSystem();
        Path dstPath = store.getRegionFileSystem().createTempName();
        FSDataOutputStream stream = fs.create(dstPath, null, true, 512, (short)3, 1024L, null);
        stream.writeChars("CORRUPT FILE!!!!");
        stream.close();
        Path origPath = store.getRegionFileSystem().commitStoreFile(Bytes.toString(COLUMN_FAMILY), dstPath);
        try {
            store.moveFileIntoPlace(origPath);
        }
        catch (Exception e) {
            assert (fs.exists(origPath));
            assert (!fs.exists(dstPath));
            System.out.println("testCompactionWithCorruptResult Passed");
            return;
        }
        Assert.fail((String)"testCompactionWithCorruptResult failed since no exception wasthrown while completing a corrupt file");
    }

    @Test
    public void testTrackingCompactionRequest() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplitThread thread = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        CountDownLatch latch = new CountDownLatch(1);
        TrackableCompactionRequest request = new TrackableCompactionRequest(latch);
        thread.requestCompaction(this.r, store, "test custom comapction", 1, request);
        latch.await();
        thread.interruptIfNecessary();
    }

    @Test
    public void testMultipleCustomCompactionRequests() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplitThread thread = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        int numStores = this.r.getStores().size();
        ArrayList<Pair<TrackableCompactionRequest, Store>> requests = new ArrayList<Pair<TrackableCompactionRequest, Store>>(numStores);
        CountDownLatch latch = new CountDownLatch(numStores);
        for (Store store : this.r.getStores()) {
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            requests.add(new Pair<TrackableCompactionRequest, Store>(new TrackableCompactionRequest(latch), store));
        }
        thread.requestCompaction((Region)this.r, "test mulitple custom comapctions", 1, Collections.unmodifiableList(requests));
        latch.await();
        thread.interruptIfNecessary();
    }

    @Test
    public void testCompactionQueuePriorities() throws Exception {
        int i;
        Configuration conf = HBaseConfiguration.create();
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockServer.getChoreService()).thenReturn((Object)new ChoreService("test"));
        CompactSplitThread cst = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)cst);
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)r.compact((CompactionContext)Matchers.any(CompactionContext.class), (Store)Matchers.any(Store.class), (CompactionThroughputController)Matchers.any(CompactionThroughputController.class))).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                ((CompactionContext)invocation.getArgumentAt(0, CompactionContext.class)).compact((CompactionThroughputController)invocation.getArgumentAt(2, CompactionThroughputController.class));
                return true;
            }
        });
        ArrayList<Integer> results = new ArrayList<Integer>();
        StoreMockMaker sm = new StoreMockMaker(results);
        StoreMockMaker sm2 = new StoreMockMaker(results);
        Store store = sm.createStoreMock("store1");
        Store store2 = sm2.createStoreMock("store2");
        BlockingStoreMockMaker blocker = new BlockingStoreMockMaker();
        cst.requestSystemCompaction(r, blocker.createStoreMock(1, "b-pri1"), "b-pri1");
        BlockingStoreMockMaker.BlockingCompactionContext currentBlock = blocker.waitForBlocking();
        for (i = 0; i < 4; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store, "s1-pri3");
        for (i = 0; i < 3; ++i) {
            sm2.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store2, "s2-pri4");
        for (i = 0; i < 2; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store, "s1-pri1");
        cst.requestSystemCompaction(r, blocker.createStoreMock(2, "b-pri2"), "b-pri2");
        currentBlock.unblock();
        currentBlock = blocker.waitForBlocking();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)results.get(0).intValue());
        for (i = 0; i < 2; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, blocker.createStoreMock(7, "b-pri7"), "b-pri7");
        currentBlock.unblock();
        currentBlock = blocker.waitForBlocking();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(1).intValue());
        Assert.assertEquals((long)2L, (long)results.get(2).intValue());
        currentBlock.unblock();
        cst.interruptIfNecessary();
    }

    private static StoreFile createFile() throws Exception {
        StoreFile sf = (StoreFile)Mockito.mock(StoreFile.class);
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("file"));
        StoreFile.Reader r = (StoreFile.Reader)Mockito.mock(StoreFile.Reader.class);
        Mockito.when((Object)r.length()).thenReturn((Object)10L);
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        return sf;
    }

    public static class TrackableCompactionRequest
    extends CompactionRequest {
        private CountDownLatch done;

        public TrackableCompactionRequest(CountDownLatch finished) {
            this.done = finished;
        }

        @Override
        public void afterExecute() {
            super.afterExecute();
            this.done.countDown();
        }
    }

    public class BlockingStoreMockMaker
    extends StatefulStoreMockMaker {
        BlockingCompactionContext blocked = null;

        @Override
        public CompactionContext selectCompaction() {
            this.blocked = new BlockingCompactionContext();
            try {
                this.blocked.select(null, false, false, false);
            }
            catch (IOException ex) {
                Assert.fail((String)"Shouldn't happen");
            }
            return this.blocked;
        }

        @Override
        public void cancelCompaction(Object object) {
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public BlockingCompactionContext waitForBlocking() {
            while (this.blocked == null || !this.blocked.isInCompact) {
                Threads.sleepWithoutInterrupt(50L);
            }
            BlockingCompactionContext ctx = this.blocked;
            this.blocked = null;
            return ctx;
        }

        @Override
        public Store createStoreMock(String name) throws Exception {
            return this.createStoreMock(Integer.MIN_VALUE, name);
        }

        public Store createStoreMock(int priority, String name) throws Exception {
            Store s = super.createStoreMock(name);
            Mockito.when((Object)s.getCompactPriority()).thenReturn((Object)priority);
            return s;
        }

        public class BlockingCompactionContext
        extends CompactionContext {
            public volatile boolean isInCompact = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unblock() {
                BlockingCompactionContext blockingCompactionContext = this;
                synchronized (blockingCompactionContext) {
                    this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Path> compact(CompactionThroughputController throughputController) throws IOException {
                try {
                    this.isInCompact = true;
                    BlockingCompactionContext blockingCompactionContext = this;
                    synchronized (blockingCompactionContext) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    Assume.assumeNoException((Throwable)e);
                }
                return new ArrayList<Path>();
            }

            @Override
            public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
                return new ArrayList<StoreFile>();
            }

            @Override
            public boolean select(List<StoreFile> f, boolean i, boolean m, boolean e) throws IOException {
                this.request = new CompactionRequest(new ArrayList<StoreFile>());
                return true;
            }
        }
    }

    private class StoreMockMaker
    extends StatefulStoreMockMaker {
        public ArrayList<StoreFile> compacting = new ArrayList();
        public ArrayList<StoreFile> notCompacting = new ArrayList();
        private ArrayList<Integer> results;

        public StoreMockMaker(ArrayList<Integer> results) {
            this.results = results;
        }

        @Override
        public synchronized CompactionContext selectCompaction() {
            TestCompactionContext ctx = new TestCompactionContext(new ArrayList<StoreFile>(this.notCompacting));
            this.compacting.addAll(this.notCompacting);
            this.notCompacting.clear();
            try {
                ((CompactionContext)ctx).select(null, false, false, false);
            }
            catch (IOException ex) {
                Assert.fail((String)"Shouldn't happen");
            }
            return ctx;
        }

        @Override
        public synchronized void cancelCompaction(Object object) {
            TestCompactionContext ctx = (TestCompactionContext)object;
            this.compacting.removeAll(ctx.selectedFiles);
            this.notCompacting.addAll(ctx.selectedFiles);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void finishCompaction(List<StoreFile> sfs) {
            if (sfs.isEmpty()) {
                return;
            }
            ArrayList<Integer> arrayList = this.results;
            synchronized (arrayList) {
                this.results.add(sfs.size());
            }
            this.compacting.removeAll(sfs);
        }

        @Override
        public int getPriority() {
            return 7 - this.compacting.size() - this.notCompacting.size();
        }

        public class TestCompactionContext
        extends CompactionContext {
            private List<StoreFile> selectedFiles;

            public TestCompactionContext(List<StoreFile> selectedFiles) {
                this.selectedFiles = selectedFiles;
            }

            @Override
            public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
                return new ArrayList<StoreFile>();
            }

            @Override
            public boolean select(List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
                this.request = new CompactionRequest(this.selectedFiles);
                this.request.setPriority(StoreMockMaker.this.getPriority());
                return true;
            }

            @Override
            public List<Path> compact(CompactionThroughputController throughputController) throws IOException {
                StoreMockMaker.this.finishCompaction(this.selectedFiles);
                return new ArrayList<Path>();
            }
        }
    }
}

