/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileManager;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class DefaultStoreEngine
extends StoreEngine<DefaultStoreFlusher, RatioBasedCompactionPolicy, DefaultCompactor, DefaultStoreFileManager> {
    public static final String DEFAULT_STORE_FLUSHER_CLASS_KEY = "hbase.hstore.defaultengine.storeflusher.class";
    public static final String DEFAULT_COMPACTOR_CLASS_KEY = "hbase.hstore.defaultengine.compactor.class";
    public static final String DEFAULT_COMPACTION_POLICY_CLASS_KEY = "hbase.hstore.defaultengine.compactionpolicy.class";
    private static final Class<? extends DefaultStoreFlusher> DEFAULT_STORE_FLUSHER_CLASS = DefaultStoreFlusher.class;
    private static final Class<? extends DefaultCompactor> DEFAULT_COMPACTOR_CLASS = DefaultCompactor.class;
    private static final Class<? extends RatioBasedCompactionPolicy> DEFAULT_COMPACTION_POLICY_CLASS = ExploringCompactionPolicy.class;

    @Override
    public boolean needsCompaction(List<StoreFile> filesCompacting) {
        return ((RatioBasedCompactionPolicy)this.compactionPolicy).needsCompaction(((DefaultStoreFileManager)this.storeFileManager).getStorefiles(), filesCompacting);
    }

    @Override
    protected void createComponents(Configuration conf, Store store, KeyValue.KVComparator kvComparator) throws IOException {
        String className = conf.get(DEFAULT_COMPACTOR_CLASS_KEY, DEFAULT_COMPACTOR_CLASS.getName());
        try {
            this.compactor = (Compactor)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class, Store.class}, new Object[]{conf, store});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured compactor '" + className + "'", e);
        }
        className = conf.get(DEFAULT_COMPACTION_POLICY_CLASS_KEY, DEFAULT_COMPACTION_POLICY_CLASS.getName());
        try {
            this.compactionPolicy = (CompactionPolicy)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class, StoreConfigInformation.class}, new Object[]{conf, store});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured compaction policy '" + className + "'", e);
        }
        this.storeFileManager = new DefaultStoreFileManager(kvComparator, conf, ((RatioBasedCompactionPolicy)this.compactionPolicy).getConf());
        className = conf.get(DEFAULT_STORE_FLUSHER_CLASS_KEY, DEFAULT_STORE_FLUSHER_CLASS.getName());
        try {
            this.storeFlusher = (StoreFlusher)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class, Store.class}, new Object[]{conf, store});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured store flusher '" + className + "'", e);
        }
    }

    @Override
    public CompactionContext createCompaction() {
        return new DefaultCompactionContext();
    }

    private class DefaultCompactionContext
    extends CompactionContext {
        private DefaultCompactionContext() {
        }

        @Override
        public boolean select(List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
            this.request = ((RatioBasedCompactionPolicy)DefaultStoreEngine.this.compactionPolicy).selectCompaction(((DefaultStoreFileManager)DefaultStoreEngine.this.storeFileManager).getStorefiles(), filesCompacting, isUserCompaction, mayUseOffPeak, forceMajor);
            return this.request != null;
        }

        @Override
        public List<Path> compact(CompactionThroughputController throughputController) throws IOException {
            return ((DefaultCompactor)DefaultStoreEngine.this.compactor).compact(this.request, throughputController);
        }

        @Override
        public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
            return ((RatioBasedCompactionPolicy)DefaultStoreEngine.this.compactionPolicy).preSelectCompactionForCoprocessor(((DefaultStoreFileManager)DefaultStoreEngine.this.storeFileManager).getStorefiles(), filesCompacting);
        }
    }
}

