/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class RateLimiter {
    public static final String QUOTA_RATE_LIMITER_CONF_KEY = "hbase.quota.rate.limiter";
    private long tunit = 1000L;
    private long limit = Long.MAX_VALUE;
    private long avail = Long.MAX_VALUE;

    abstract long refill(long var1);

    abstract long getWaitInterval(long var1, long var3, long var5);

    public void set(long limit, TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLISECONDS: {
                this.tunit = 1L;
                break;
            }
            case SECONDS: {
                this.tunit = 1000L;
                break;
            }
            case MINUTES: {
                this.tunit = 60000L;
                break;
            }
            case HOURS: {
                this.tunit = 3600000L;
                break;
            }
            case DAYS: {
                this.tunit = 86400000L;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported " + timeUnit.name() + " TimeUnit.");
            }
        }
        this.limit = limit;
        this.avail = limit;
    }

    public String toString() {
        String rateLimiter = this.getClass().getSimpleName();
        if (this.limit == Long.MAX_VALUE) {
            return rateLimiter + "(Bypass)";
        }
        return rateLimiter + "(avail=" + this.avail + " limit=" + this.limit + " tunit=" + this.tunit + ")";
    }

    public synchronized void update(RateLimiter other) {
        this.tunit = other.tunit;
        if (this.limit < other.limit) {
            this.avail += other.limit - this.limit;
        }
        this.limit = other.limit;
    }

    public synchronized boolean isBypass() {
        return this.limit == Long.MAX_VALUE;
    }

    public synchronized long getLimit() {
        return this.limit;
    }

    public synchronized long getAvailable() {
        return this.avail;
    }

    protected long getTimeUnitInMillis() {
        return this.tunit;
    }

    public boolean canExecute() {
        return this.canExecute(1L);
    }

    public synchronized boolean canExecute(long amount) {
        long refillAmount = this.refill(this.limit);
        if (refillAmount == 0L && this.avail < amount) {
            return false;
        }
        this.avail = this.avail <= Long.MAX_VALUE - refillAmount ? Math.max(0L, Math.min(this.avail + refillAmount, this.limit)) : Math.max(0L, this.limit);
        return this.avail >= amount;
    }

    public void consume() {
        this.consume(1L);
    }

    public synchronized void consume(long amount) {
        this.avail -= amount;
        if (this.avail < 0L) {
            this.avail = 0L;
        }
    }

    public long waitInterval() {
        return this.waitInterval(1L);
    }

    public synchronized long waitInterval(long amount) {
        return amount <= this.avail ? 0L : this.getWaitInterval(this.limit, this.avail, amount);
    }

    @VisibleForTesting
    public void setNextRefillTime(long nextRefillTime) {
        this.setNextRefillTime(nextRefillTime);
    }

    public long getNextRefillTime() {
        return this.getNextRefillTime();
    }
}

